@component('backend.layouts.components.main',['title' => 'مدیریت تیکت ها', 'titleBar'=>true , 'button' => '' , 'route' => 'admin.tickets.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">تیکت</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست تیکت</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>آیدی</th>
                            <th>عنوان</th>
                            <th>تیکت برای</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($tickets as $ticket)
                            <tr>
                                <td>{{$ticket->tracking_id}}</td>
                                <td>
                                    {{$ticket->title}}
                                </td>
                                <td>
                                    @if($ticket->ticketable)
                                        {{$ticket->ticketable->title}}
                                    @endif
                                </td>
                                <td>
                                    @switch($ticket->status)
                                        @case('answered')
                                        <span class="badge badge-pill badge-success">پاسخ داده شده</span>
                                        @break
                                        @case('waiting')
                                        <span class="badge badge-pill badge-primary">در انتظار پاسخ</span>
                                        @break
                                        @case('closed')
                                        <span class="badge badge-pill badge-danger">بسته شده</span>
                                        @break
                                    @endswitch
                                </td>
                                <td>
                                    <form action="{{route('admin.tickets.destroy', $ticket->id)}}" method="post"
                                          id="delete-{{$ticket->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    <a href="{{route('admin.tickets.edit', $ticket->id)}}" role="button"
                                       class="btn btn-success light sharp" title="ویرایش">
                                        <i class="fa fa-pencil"
                                           onclick="document.getElementById('edit-{{$ticket->id}}').submit()"></i>
                                    </a>
                                    <button onclick="document.getElementById('delete-{{$ticket->id}}').submit()"
                                            role="button" class="btn btn-danger light sharp" title="حذف">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>

                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$tickets->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
