<?php

namespace Modules\Ticket\Http\Controllers\Front;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Ticket\Entities\Reply;
use Modules\Ticket\Entities\Ticket;
use Modules\Ticket\Notifications\TicketAdminNotify;
use Modules\Ticket\Notifications\TicketClientNotify;
use Modules\User\Entities\User;

class TicketController extends Controller
{
    use SEOTools;
    public function __construct()
    {
        $this->middleware('can:view,ticket')->only('show');
    }

    public function index()
    {
        $this->seo()
            ->settitle('تیکت های پشتیبانی شما');
        return view('user::frontend.tickets.all');
    }


    public function reply(Request $request, Ticket $ticket)
    {
        $validData = $request->validate([
            'message' => 'required|min:10'
        ]);
        $ticket->replies()->create([
            'message' => $validData['message'],
            'for' => 'user'
        ]);
        $ticket->update(['status' => 'waiting']);
        $ticket->user->notify(new TicketAdminNotify('09058775382' , 'pln1ghzb09' , $ticket->tracking_id));
        alert()->success('پاسخ شما با موفقیت ارسال شد');
        return back();
    }

    public function create()
    {
        $this->seo()
            ->settitle('ایجاد تیکت جدید');
        return view('user::frontend.tickets.create');
    }

    public function store(Request $request , User $user)
    {
        $validData = $request->validate([
            'message' => 'required',
            'title' => 'required',
            'section' => 'required',
            'priority' => 'required',
            'ticketable_id' => 'required',
            'ticketable_type' => 'required',
        ]);
        $ticket = $user->tickets()->create([
            'message' => $validData['message'],
            'title' =>  $validData['title'],
            'section' =>  $validData['section'],
            'priority' =>  $validData['priority'],
            'ticketable_id' =>  $validData['ticketable_id'],
            'ticketable_type' =>  $validData['ticketable_type'],
            'status' => 'waiting',
            'tracking_id' => rand(10000,20000)
        ]);
        $user->notify(new TicketAdminNotify('09058775382' , 'bhw09v52gt' , $ticket->tracking_id));
        alert()->success("تیکت با موفقیت ایجاد شد. لطفا تا پاسخ پشتیبانی تیکت جدید درباره ی همین موضوع ارسال نفرمایید");
        return back();
    }

    public function show(Ticket $ticket)
    {
        $this->seo()
            ->settitle("جزئیات تیکت $ticket->tracking_id");
        return view('user::frontend.tickets.show', compact('ticket'));
    }


    public function edit($id)
    {
        return view('ticket::edit');
    }


    public function update(Request $request, $id)
    {
        //
    }


    public function destroy($id)
    {
        //
    }
}
