<?php

namespace Modules\Ticket\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\User\Entities\User;

class Ticket extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'section',
        'priority',
        'status',
        'message',
        'user_id',
        'tracking_id',
        'ticketable_type',
        'ticketable_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function ticketable()
    {
        return $this->morphTo();
    }

    public function replies()
    {
        return $this->hasMany(Reply::class);
    }
}
