<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;

Route::middleware(['auth' , 'can:edit-profile'])->prefix('profile')->group(function () {
    Route::get('projects' , 'Front\ProjectController@index')->name('profile.projects');
    Route::get('projects/{project:tracking_id}' , 'Front\ProjectController@show')->name('profile.projects.show');
    Route::get('projects/payment/{order}' , 'Front\PaymentController@payment')->name('profile.projects.payment');
    Route::patch('project/{project:tracking_id}' , 'Front\ProjectController@editLevels')->name('profile.projects.edit-levels');
    Route::middleware('signed')->group(function () {
        Route::get('/' , 'Front\ProjectController@getUrl')->name('get.projects.url');
    });
});
