<?php

namespace Modules\Project\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Modules\Project\Notifications\channels\PaymentSmsChannel;

class SuccessfulProjectPurchase extends Notification
{
    use Queueable;

    public $phone;
    public $domain;
    public $pattern;
    public function __construct($phone , $domain , $pattern)
    {
        $this->phone = $phone;
        $this->domain = $domain;
        $this->pattern = $pattern;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [PaymentSmsChannel::class];
    }


    public function toPaymentSmsChannel($notifiable)
    {
        return [
            'phone' => $this->phone,
            'pattern' => $this->pattern,
            'domain' => $this->domain
        ];
    }
}
