<?php

namespace Modules\Project\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Modules\Project\Notifications\channels\ClientSmsChannel;

class ExpirationClientNotify extends Notification
{
    use Queueable;

    public $domain_name;
    public $renew_date;
    public $project_name;
    public $start_date;
    public $phone;

    public function __construct($domain_name , $renew_date , $project_name , $start_date , $phone )
    {
        $this->phone = $phone;
        $this->domain_name = $domain_name;
        $this->renew_date = $renew_date;
        $this->project_name = $project_name;
        $this->start_date = $start_date;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [ClientSmsChannel::class];
    }

    public function toClientSmsChannel()
    {
        return [
            'phone' => $this->phone,
            'domain_name' => $this->domain_name,
            'renew_date' => $this->renew_date,
            'project_name' => $this->project_name,
            'start_date' => $this->start_date,
        ];
    }
}
