<?php

namespace Modules\Project\Http\Controllers\Front;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Storage;
use Modules\Project\Entities\Project;
use Modules\Project\Notifications\EditProjectNotify;
use Modules\User\Entities\User;

class ProjectController extends Controller
{
    use SEOTools;
    public function __construct()
    {
        $this->middleware('can:view,project')->only('show');
    }


    public function index()
    {
        $this->seo()
            ->settitle('پروژه های شما');
        return view('user::frontend.projects.all');
    }

    public function show(Project $project)
    {
        $this->seo()
            ->settitle("جزئیات پروژه $project->tracking_id");
        return view('user::frontend.projects.show' , compact('project'));
    }

    public function editLevels(Project $project , Request $request)
    {
        $validData = $request->validate([
           'edit_level1' => 'sometimes|required',
           'edit_level2' => 'sometimes|required',
        ]);
        $project->update($validData);
        $project->user->notify(new EditProjectNotify($project->user->phone , $project->domain , $project->tracking_id , 'kv9ktbs0a0'));
        $project->user->notify(new EditProjectNotify('09058775382' , $project->domain , $project->tracking_id , '4atp0ttj97'));
        alert()->success('اصلاحیه شما با موفقیت ارسال شد و بعد از بررسی اعمال خواهد شد.' , 'موفق')->confirmButton('باشه')->closeOnClickOutside();
        return back();
    }

    public function getUrl()
    {
        return Storage::download(request('path'));
    }
}
