<?php

namespace Modules\Project\Http\Controllers\Front;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Str;
use Modules\Order\Entities\Order;

class PaymentController extends Controller
{
    public function __construct()
    {
        $this->middleware('can:view,order')->only('payment');
    }

    public function payment(Order $order)
    {

        $token = config('services.payping.token');
        $res_number = Str::random();
        $args = [
            'amount' => $order->price,
            'payerName' => \auth()->user()->name,
            'returnUrl' =>route('payment.projects.callback'),
            'clientRefId' => $res_number
        ];
        $payment = new \PayPing\Payment($token);

        try {
            $payment->pay($args);
        } catch (\Exception $e) {
            $errors = collect(json_decode($e->getMessage(),true));
            alert()->error($errors->first());
            return redirect(route('profile.dashboard'));
        }

        $order->payments()->create([
            'res_number' => $res_number,
            'price' => $order->price
        ]);
        return redirect($payment->getPayUrl());
   }
}
//Error converting value {null} to type 'System.Int32'. Path 'amount', line 1, position 36.