<?php

namespace Modules\Project\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Modules\Order\Entities\Order;
use Modules\Ticket\Entities\Ticket;
use Modules\User\Entities\User;

class Project extends Model
{
    use HasFactory;
    use Notifiable;
    protected $fillable = [
        'title',
        'status',
        'tracking_id',
        'start_date',
        'edit_level1',
        'edit_level2',
        'user_id',
        'renew_date',
        'domain',
        'username',
        'password',
        'course_file',
        'price',
        'login_info'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function extras()
    {
        return $this->hasMany(Extra::class);
    }

    public function orders()
    {
        return $this->belongsToMany(Order::class);
    }

    public function tickets()
    {
        return $this->morphMany(Ticket::class , 'ticketable');
    }
}
