<?php

namespace Modules\Post\Http\Controllers\Front;

use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Category\Entities\Category;
use Modules\Portfolio\Entities\Portfolio;
use Modules\Post\Entities\Post;

class PostController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()
            ->settitle('وبلاگ')
            ->setDescription('آموزش طراحی سایت، طراحی اپلیکیشن، سئو و دیجیتال مارکتینگ از جمله مطالبی است که در وبلاگ کاراوب منتشر میشود');
        $posts = Post::with('categories')
            ->where('status' , 1)
            ->latest()
            ->simplePaginate(8);
        return view('post::frontend.all' , compact('posts'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('post::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    public function show(Post $post)
    {
        $this->seo()
            ->settitle($post->title)
            ->setDescription($post->meta_description)
            ->addImages(asset($post->image));
        $this->seo()->jsonLd()->setType('Article');
        $this->seo()->jsonLd()->setImages(asset($post->image));
        $this->seo()->jsonLd()->setUrl(asset('blog/'.$post->slug));
        $this->seo()->opengraph()->addProperty('type', 'article');
        SEOMeta::addKeyword($post->meta_keywords);
        $categories = Category::with('portfolios')
            ->where('category_type' , Post::class)
            ->whereNull('parent_id')
            ->get();
        $posts = Post::latest()->paginate(4);
        return view('post::frontend.show' , compact(['post' ,'categories' , 'posts']));
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('post::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
