@component('backend.layouts.components.main',['title' => 'افزودن نمونه کار جدید','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">افزودن نمونه کار جدید</li>al
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات نمونه کار</h4>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <input name="title" type="text"
                           class="form-control input-rounded @error('title') is-invalid @enderror" placeholder="عنوان"
                           form="store" required value="{{old('title')}}">
                    @error('title')
                    <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                    @enderror
                </div>
                <div class="custom-tab-1">
                    <ul class="nav nav-tabs">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#content">
                                <i class="la la-file-text ml-2"></i>
                                محتوا
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#seo">
                                <i class="la la-rocket ml-2"></i>
                                سئو
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#detail">
                                <i class="la la-dot-circle ml-2"></i>
                                جزئیات
                            </a>
                        </li>
                    </ul>
                    <form action="{{route('admin.portfolios.store')}}" method="post" id="store">
                        @csrf
                        @method('post')
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="content" role="tabpanel">
                                <div class="pt-4">
                                    <div class="basic-form">
                                            <div class="card-body">
                                                <textarea class="@error('desc') is-invalid @enderror"  id="editor1"
                                                          name="desc" required>{{old('desc')}}</textarea>
                                                @error('desc')
                                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                                @enderror
                                            </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="seo">
                                <div class="pt-4">
                                    <div class="card">
                                        <div class="card-header">
                                            <h4 class="card-title">سیستم نمایش در گوگل</h4>
                                            <img src="{{asset('/images/google-icon.png')}}"
                                                 style="width: 50px; height: auto">
                                        </div>
                                        <div class="card-body">
                                            <div class="results">
                                                <div class="ind">
                                                    <a class="link" id="g-link" href="#">
                                                        عنوان متا یک | عنوان متا 2 | نام وب سایت
                                                    </a>
                                                    <br/>
                                                    <a class="url" href="#">
                                                        {{asset('/')}} &#9662;
                                                    </a>
                                                    <p id="g-desc" class="desc">
                                                        لطفا توضیحاتی را درباره ی این پست بنویسید
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">عنوان متا</label>
                                        <div class="col-sm-9">
                                            <input type="text" id="meta-title" name="meta_title"
                                                   class="form-control input-rounded @error('meta_title') is-invalid @enderror"
                                                   placeholder="عنوان متا"
                                                   value="{{old('meta_title')}}">
                                            @error('meta_title')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">توضیحات متا</label>
                                        <div class="col-sm-9">
                                            <textarea placeholder="توضیحات متا" name="meta_disc"
                                                      class="form-control @error('meta_disc') is-invalid @enderror"
                                                      rows="4" id="meta-desc">{{old('meta_disc')}}</textarea>
                                            @error('meta_disc')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">کلمات کلیدی</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="keywords"
                                                   class="form-control input-rounded @error('keywords') is-invalid @enderror"
                                                   placeholder="مثلا: طراحی سایت , طراحی سایت من"
                                                   value="{{old('keywords')}}">
                                            @error('keywords')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">نوع پست</label>
                                        <div class="col-sm-9">
                                            <div class="dropdown bootstrap-select form-control default-select dropup">
                                                <select name="meta_type"
                                                        class="form-control default-select input-rounded @error('meta_type') is-invalid @enderror"
                                                        id="sel1"
                                                        tabindex="-98">
                                                    <option value="">انتخاب کنید</option>
                                                    <option value="Article">مقاله</option>
                                                    <option value="NewsArticle">مقاله خبری</option>
                                                    <option value="VideoObject">ویدیو</option>
                                                </select>
                                                @error('meta_type')
                                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                                @enderror
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="detail">
                                <div class="pt-4">
                                    <p class="text-justify">
                                        <i class="fa fa-circle text-blue ml-1"></i>
                                        لینک به صورت پیش فرض از عنوان نوشته ساخته میشود، درصورتی که قصد تغییر آن را
                                        دارید در این باکس لینک را وارد کنید
                                    </p>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">لینک</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="slug"
                                                   class="form-control input-rounded @error('slug') is-invalid @enderror"
                                                   placeholder="لینک" value="{{old('slug')}}">
                                            @error('slug')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">لینک پروژه</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="link"
                                                   class="form-control input-rounded @error('link') is-invalid @enderror"
                                                   placeholder="لینک پروژه" value="{{old('link')}}">
                                            @error('link')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">تاریخ راه اندازی پروژه</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="project_running_date"
                                                   class="form-control input-rounded @error('project_running_date') is-invalid @enderror"
                                                   placeholder="تاریخ راه اندازی پروژه"
                                                   value="{{old('project_running_date')}}">
                                            @error('project_running_date')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">درصد پیشرفت پروژه</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="project_progress"
                                                   class="form-control input-rounded @error('project_progress') is-invalid @enderror"
                                                   placeholder="درصد پیشرفت پروژه"
                                                   value="{{old('project_progress')}}">
                                            @error('project_progress')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">تکنولوژی های استفاده شده</label>
                                        <div class="col-sm-9">
                                            <select name="techs[]" multiple
                                                    class="form-control default-select input-rounded" form="store">
                                                <option value="php">PHP</option>
                                                <option value="laravel">Laravel</option>
                                                <option value="html">html</option>
                                                <option value="css">CSS</option>
                                                <option value="javascript">Javascript</option>
                                                <option value="figma">Figma</option>
                                                <option value="wordpress">Wordpress</option>
                                                <option value="woocommerce">Woocommerce</option>
                                            </select>

                                            @error('techs')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">ترتیب</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="order_id"
                                                   class="form-control input-rounded @error('order_id') is-invalid @enderror"
                                                   placeholder="ترتیب"
                                                   value="{{old('order_id')}}">
                                            @error('order_id')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">ترکیب رنگی</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="as_colorpicker form-control" value="#7ab2fa">
                                            <input type="text" name="colors" placeholder="کد های رنگی را اضافه کنید" class="form-control input-rounded">
                                            @error('order_id')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">تصویر کاور</label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <input type="text" id="image1" class="form-control" name="image"
                                                       aria-label="Image" aria-describedby="button-image"
                                                       style="direction: ltr;border-radius: 0 50px 50px 0">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-info" type="button"
                                                            id="button-image">
                                                        انتخاب
                                                    </button>
                                                </div>
                                            </div>
                                            @error('image')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label"> لوگو</label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <input type="text" id="image2" class="form-control" name="logo"
                                                       aria-label="Image" aria-describedby="button-image"
                                                       style="direction: ltr;border-radius: 0 50px 50px 0">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-info" type="button"
                                                            id="button-image2">
                                                        انتخاب
                                                    </button>
                                                </div>
                                            </div>
                                            @error('logo')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        @if($errors->any())
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        @foreach($errors->all() as $error)
                            <p class="mb-0">{{$error}}</p>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif


        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.posts.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای ایجاد پست جدید، روی دکمه "ساختن" کلیک کنید.
                </p>
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    در صورتی که میخواهید پست منتشر شده اما در سایت نمایش داده نشود وضعیت را در حالت خاموش قرار دهید.
                </p>

                <div class="row">
                    <div class="col-md-6">
                        <div class="custom-control custom-switch toggle-switch text-right mr-4 mb-2">
                            <input type="checkbox" class="custom-control-input" id="customSwitch12" form="store"
                                   name="status" checked>
                            <label class="custom-control-label fs-14 text-black pr-2" for="customSwitch12">وضعیت</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('store').submit()">
                            <i class="fa fa-save"></i>
                            ساختن
                        </button>
                    </div>

                </div>

            </div>
        </div>
        <div class=" sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">دسته بندی</h4>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    لطفا دسته بندی مورد نظر خود را از باکس زیر انتخاب کنید
                </p>

                <select name="categories[]" multiple
                        class="form-control default-select input-rounded" form="store">
                    @include('category::backend.portfolios.partials.categories-dropdown' ,
                            [
                                'categories' => $categories,
                                'level' => 0
                                ])
                </select>
            </div>
        </div>
    </div>
    {{-- Sidebar End --}}



    {{-- Scripts --}}
@section('script')
    <script src="{{ asset('/vendor/file-manager/js/file-manager.js') }}"></script>
    <script src="{{asset('/backend/js/file-editor.js')}}"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {

            document.getElementById('button-image').addEventListener('click', (event) => {
                event.preventDefault();

                inputId = 'image1';

                window.open('/file-manager/fm-button', 'fm', 'width=1400,height=800');
            });

            // second button
            document.getElementById('button-image2').addEventListener('click', (event) => {
                event.preventDefault();

                inputId = 'image2';

                window.open('/file-manager/fm-button', 'fm', 'width=1400,height=800');
            });
        });

        // input
        let inputId = '';

        // set file link
        function fmSetLink($url) {
            document.getElementById(inputId).value = $url;
        }
    </script>
    <script>
        let meta_title = document.getElementById('meta-title');
        let meta_desc = document.getElementById('meta-desc');
        let g_link = document.getElementById('g-link');
        let g_desc = document.getElementById('g-desc');
        meta_title.addEventListener('change', function () {
            g_link.innerText = meta_title.value;
        })
        meta_desc.addEventListener('change', function () {
            g_desc.innerText = meta_desc.value;
        })
    </script>
    <!-- asColorPicker -->
    <script src="/js/jquery-asColor/jquery-asColor.min.js"></script>
    <script src="/js/jquery-asColorPicker/js/jquery-asColorPicker.min.js"></script>
    <!-- asColorPicker init -->
    <script src="/js/jquery-asColorPicker.init.js"></script>
    <script src="/backend/vendor/nestable2/js/jquery.nestable.min.js"></script>
@stop

@section('head')
    <!-- asColorpicker -->
    <link href="/js/jquery-asColorPicker/css/asColorPicker.min.css" rel="stylesheet">
    <script src="https://cdn.tiny.cloud/1/piqrm2bib3zv8de8a26kklh89gvqb0bhm9a14mjb88jwos8r/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
    <link rel="stylesheet" href="{{ asset('/backend/vendor/nestable2/css/jquery.nestable.min.css') }}">
@stop
@endcomponent
