<?php

namespace Modules\Portfolio\Http\Controllers\Frontend;

use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Category\Entities\Category;
use Modules\Portfolio\Entities\Portfolio;

class PortfolioController extends Controller
{
    use SEOTools;
    public function all()
    {
        $this->seo()
            ->settitle('نمونه کار های طراحی سایت');
        SEOMeta::addKeyword(['نمونه کار طراحی سایت']);
        $portfolios = Portfolio::with('categories')->where('status' , 1)->orderBy('order_id')->get();
        return view('portfolio::frontend.all', compact(['portfolios']));
    }

    public function show(Portfolio $portfolio)
    {
        $this->seo()
            ->settitle($portfolio->title)
            ->addImages($portfolio->image)
            ->setDescription($portfolio->meta_disc);
        $this->seo()->opengraph()->addProperty('type', 'articles');
        SEOMeta::addKeyword($portfolio->keywords);
        return view('portfolio::frontend.show' , compact('portfolio'));
    }
}
