<?php

namespace Modules\Portfolio\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Category\Entities\Category;
use Modules\Comment\Entities\Comment;

class Portfolio extends Model
{
    use HasFactory;

    protected $fillable = [
        'title' ,
        'desc' ,
        'logo' ,
        'link' ,
        'slug' ,
        'colors' ,
        'project_running_date' ,
        'keywords',
        'meta_title' ,
        'meta_disc' ,
        'meta_type',
        'order_id' ,
        'techs' ,
        'project_progress' ,
        'image' ,
        'status'
    ];

    //many to many polymorphic relationship whit categories table

    public function categories()
    {
        return $this->morphToMany(Category::class , 'categorizable');
    }

    public function comments()
    {
        return $this->morphMany(Comment::class,'commentable');
    }
}
