<?php
use Illuminate\Support\Facades\Route;

Route::resources(['pages' => 'PageController']);
Route::resources(['faqs' => 'FaqController']);
Route::post('page/new' , function (){
    $content = '<section><svg width="174" height="481" viewBox="0 0 174 481" fill="none" xmlns="http://www.w3.org/2000/svg" class="svg-header-left"><path fill-rule="evenodd" clip-rule="evenodd" d="M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z" fill="#288ed929" fill-opacity="0.6"></path></svg><div class="container"><div class="row"><div class="col-md-6"><div class="section-head"><div class="section-title"><div class="title-icon"><div id="ij0qi"><svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0)"><path d="M9.28125 4.21875C9.57465 3.87573 9.93887 3.60035 10.3489 3.41153C10.7588 3.22272 11.2049 3.12497 11.6563 3.125H38.3438C38.7951 3.12497 39.2412 3.22272 39.6511 3.41153C40.0611 3.60035 40.4254 3.87573 40.7187 4.21875L48.8719 13.7313C49.5998 14.5807 50 15.6625 50 16.7812V17.5781C50.0002 19.1249 49.5171 20.6331 48.6182 21.8919C47.7193 23.1508 46.4496 24.0973 44.9865 24.5992C43.5234 25.1011 41.94 25.1334 40.4577 24.6915C38.9754 24.2495 37.6682 23.3555 36.7188 22.1344C36.0254 23.0274 35.137 23.7499 34.1214 24.2466C33.1057 24.7433 31.9899 25.001 30.8594 25C29.7288 25.0013 28.6129 24.7437 27.5972 24.2469C26.5816 23.7502 25.6932 23.0276 25 22.1344C24.3068 23.0276 23.4184 23.7502 22.4028 24.2469C21.3871 24.7437 20.2712 25.0013 19.1406 25C18.01 25.0013 16.8941 24.7437 15.8785 24.2469C14.8628 23.7502 13.9744 23.0276 13.2812 22.1344C12.3318 23.3555 11.0246 24.2495 9.5423 24.6915C8.05998 25.1334 6.47661 25.1011 5.01351 24.5992C3.55041 24.0973 2.2807 23.1508 1.38182 21.8919C0.482943 20.6331 -0.000170621 19.1249 4.52017e-08 17.5781V16.7812C3.93986e-05 15.6625 0.400177 14.5807 1.12813 13.7313L9.28437 4.21562L9.28125 4.21875ZM14.8438 17.5781C14.8438 18.7177 15.2965 19.8107 16.1023 20.6165C16.9081 21.4223 18.001 21.875 19.1406 21.875C20.2802 21.875 21.3732 21.4223 22.179 20.6165C22.9848 19.8107 23.4375 18.7177 23.4375 17.5781C23.4375 17.1637 23.6021 16.7663 23.8951 16.4733C24.1882 16.1802 24.5856 16.0156 25 16.0156C25.4144 16.0156 25.8118 16.1802 26.1049 16.4733C26.3979 16.7663 26.5625 17.1637 26.5625 17.5781C26.5625 18.7177 27.0152 19.8107 27.821 20.6165C28.6268 21.4223 29.7198 21.875 30.8594 21.875C31.999 21.875 33.0919 21.4223 33.8977 20.6165C34.7035 19.8107 35.1562 18.7177 35.1562 17.5781C35.1562 17.1637 35.3209 16.7663 35.6139 16.4733C35.9069 16.1802 36.3043 16.0156 36.7188 16.0156C37.1332 16.0156 37.5306 16.1802 37.8236 16.4733C38.1166 16.7663 38.2812 17.1637 38.2812 17.5781C38.2813 18.7177 38.734 19.8107 39.5398 20.6165C40.3456 21.4223 41.4385 21.875 42.5781 21.875C43.7177 21.875 44.8107 21.4223 45.6165 20.6165C46.4223 19.8107 46.875 18.7177 46.875 17.5781V16.7812C46.875 16.4088 46.742 16.0487 46.5 15.7656L38.3438 6.25H11.6563L3.5 15.7656C3.25796 16.0487 3.12497 16.4088 3.125 16.7812V17.5781C3.125 18.7177 3.57771 19.8107 4.38353 20.6165C5.18935 21.4223 6.28227 21.875 7.42188 21.875C8.56148 21.875 9.6544 21.4223 10.4602 20.6165C11.266 19.8107 11.7188 18.7177 11.7188 17.5781C11.7187 17.1637 11.8834 16.7663 12.1764 16.4733C12.4694 16.1802 12.8668 16.0156 13.2812 16.0156C13.6957 16.0156 14.0931 16.1802 14.3861 16.4733C14.6791 16.7663 14.8438 17.1637 14.8438 17.5781V17.5781ZM4.6875 26.5625C5.1019 26.5625 5.49933 26.7271 5.79235 27.0201C6.08538 27.3132 6.25 27.7106 6.25 28.125V46.875H9.375V31.25C9.375 30.4212 9.70424 29.6263 10.2903 29.0403C10.8763 28.4542 11.6712 28.125 12.5 28.125H21.875C22.7038 28.125 23.4987 28.4542 24.0847 29.0403C24.6708 29.6263 25 30.4212 25 31.25V46.875H43.75V28.125C43.75 27.7106 43.9146 27.3132 44.2076 27.0201C44.5007 26.7271 44.8981 26.5625 45.3125 26.5625C45.7269 26.5625 46.1243 26.7271 46.4174 27.0201C46.7104 27.3132 46.875 27.7106 46.875 28.125V46.875H48.4375C48.8519 46.875 49.2493 47.0396 49.5424 47.3326C49.8354 47.6257 50 48.0231 50 48.4375C50 48.8519 49.8354 49.2493 49.5424 49.5424C49.2493 49.8354 48.8519 50 48.4375 50H1.5625C1.1481 50 0.750671 49.8354 0.457646 49.5424C0.16462 49.2493 4.52017e-08 48.8519 4.52017e-08 48.4375C4.52017e-08 48.0231 0.16462 47.6257 0.457646 47.3326C0.750671 47.0396 1.1481 46.875 1.5625 46.875H3.125V28.125C3.125 27.7106 3.28962 27.3132 3.58265 27.0201C3.87567 26.7271 4.2731 26.5625 4.6875 26.5625V26.5625ZM12.5 46.875H21.875V31.25H12.5V46.875ZM28.125 31.25C28.125 30.4212 28.4542 29.6263 29.0403 29.0403C29.6263 28.4542 30.4212 28.125 31.25 28.125H37.5C38.3288 28.125 39.1237 28.4542 39.7097 29.0403C40.2958 29.6263 40.625 30.4212 40.625 31.25V40.625C40.625 41.4538 40.2958 42.2487 39.7097 42.8347C39.1237 43.4208 38.3288 43.75 37.5 43.75H31.25C30.4212 43.75 29.6263 43.4208 29.0403 42.8347C28.4542 42.2487 28.125 41.4538 28.125 40.625V31.25ZM37.5 31.25H31.25V40.625H37.5V31.25Z" fill="#288ED9"></path></g><defs><clipPath id="clip0"><rect width="50" height="50" fill="white"></rect></clipPath></defs></svg></div></div><div class="title-box"><h2 class="title"> طراحی سایت فروشگاهی در کاراوب</h2><p id="i7s6l"> <strong>بررسی این نوع وب سایت</strong></p><div class="blue-line"></div></div></div></div><p id="ivq9j">طراحی سایت فروشگاهی از انواع دیگر <a data-cke-saved-href="https://karawebs.com" href="https://karawebs.com">طراحی سایت </a>میباشد که گروه ما به صورت بسیار حرفه ای به انجام آن میپردازد. امروزه همه کسب و کار ها به سمت آنلاین شدن میروند! اگر میخواهید از رقبای خود عقب نمانید، از همین امروز به فکر باشید. در این مطلب سعی داریم تا به بررسی مزایا و معایب <strong>طراحی سایت فروشگاهی</strong> بپردازیم. <strong>طراحی فروشگاه اینترنتی</strong> بحث داغ این روز هاست! فروش در اینستاگرام بهتر است یا اینکه باید به فکر <strong>طراحی فروشگاه اینترنتی</strong> باشید؟ کدام بیشتر شما را به سود میرساند؟<br/>با ما باشید تا به بررسی این موضوع بپردازیم.</p><ul class="kw-list1"><li>پشتیبانی 24 ساعته</li><li id="ijvip">امنیت فوق العاده</li><li id="ibx5j">سئوی استاندارد</li><li id="i9yzf">امکان ارتقاء به سایت چند فروشندگی</li><li id="ih8pa">پنل مدیریت حرفه ای</li></ul><a href="#faqs" class="kw-btn-blue">سوالات متداول</a><a href="https://karawebs.com/online-store-prices" class="kw-btn-blue">تعرفه و امکانات</a></div><div class="col-md-6"><img src="/backend/images/grapesjs/1624019759-online-store.png" alt="" data-aos="fade-up" class="aos-init aos-animate"/></div></div></div></section><section class="kw-p"><div class="container"><div id="iithp4" class="section-head"><div class="section-title"><div class="title-icon"><div class="title-icon"><svg width="50" height="50" viewBox="0 0 28 31" fill="none" xmlns="http://www.w3.org/2000/svg" id="ip30j"><path d="M16.2511 4.875H17.8761V3.25C17.8761 2.81902 17.7049 2.4057 17.4002 2.10095C17.0954 1.79621 16.6821 1.625 16.2511 1.625H11.3761C10.9451 1.625 10.5318 1.79621 10.2271 2.10095C9.92233 2.4057 9.75113 2.81902 9.75113 3.25V4.875H11.3761V8.242L2.08925 24.3262C1.79293 24.8195 1.63286 25.3825 1.62539 25.9578C1.61792 26.5331 1.76333 27.1001 2.04675 27.6009C2.33016 28.1016 2.74143 28.5181 3.23854 28.8079C3.73564 29.0976 4.30075 29.2502 4.87613 29.25H22.7511C23.3265 29.2502 23.8916 29.0976 24.3887 28.8079C24.8858 28.5181 25.2971 28.1016 25.5805 27.6009C25.8639 27.1001 26.0093 26.5331 26.0019 25.9578C25.9944 25.3825 25.8343 24.8195 25.538 24.3262L16.2511 8.242V4.875ZM4.87613 30.875C3.99846 30.8752 3.13702 30.6385 2.38272 30.1898C1.62842 29.7411 1.00924 29.0971 0.590535 28.3257C0.171827 27.5544 -0.0308794 26.6843 0.00381014 25.8073C0.0384997 24.9303 0.309298 24.079 0.787625 23.3431L9.75113 7.81787V6.5C9.32015 6.5 8.90682 6.32879 8.60208 6.02405C8.29733 5.7193 8.12613 5.30598 8.12613 4.875V3.25C8.12613 2.38805 8.46854 1.5614 9.07803 0.951903C9.68752 0.34241 10.5142 0 11.3761 0H16.2511C17.1131 0 17.9397 0.34241 18.5492 0.951903C19.1587 1.5614 19.5011 2.38805 19.5011 3.25V4.875C19.5011 5.30598 19.3299 5.7193 19.0252 6.02405C18.7204 6.32879 18.3071 6.5 17.8761 6.5V7.81787L26.8396 23.3431C27.318 24.079 27.5888 24.9303 27.6234 25.8073C27.6581 26.6843 27.4554 27.5544 27.0367 28.3257C26.618 29.0971 25.9988 29.7411 25.2445 30.1898C24.4902 30.6385 23.6288 30.8752 22.7511 30.875H4.87613ZM15.1039 19.9745L17.7461 17.3323L22.7511 26H4.87613L10.8236 15.6975L15.1039 19.9745ZM15.1039 22.2722L11.173 18.343L7.69062 24.375H19.9366L17.3984 19.9777L15.1039 22.2722ZM14.6261 11.375C15.0571 11.375 15.4704 11.5462 15.7752 11.851C16.0799 12.1557 16.2511 12.569 16.2511 13C16.2511 13.431 16.0799 13.8443 15.7752 14.149C15.4704 14.4538 15.0571 14.625 14.6261 14.625C14.1951 14.625 13.7818 14.4538 13.4771 14.149C13.1723 13.8443 13.0011 13.431 13.0011 13C13.0011 12.569 13.1723 12.1557 13.4771 11.851C13.7818 11.5462 14.1951 11.375 14.6261 11.375V11.375Z" fill="#288ED9"></path></svg></div></div><div class="title-box"><h3 class="title"> برخی نمونه کار ها</h3><p id="i6kfnf">خلاقیت، کیفیت، زیبایی</p><div class="blue-line"></div></div></div></div><div id="i0uqh" class="row"><div class="col-md-4 col-lg-3"><div class="kw-p-items"><div class="kw-p-item kw-wrapper kw-wrapper-br pt-0"><div class="kw-p-image"><img src="https://karawebs.com/images/1619518884moshtaqi.jpg" alt="" id="ivo4b"/></div><div class="kw-p-details"><div class="titles"><h3 class="kw-p-title">داروخانه دکتر مشتاقی</h3><p class="subtitle">طراحی سایت فروشگاهی</p></div><div class="kw-p-btn"><a href="https://karawebs.com/portfolios/moahtaqi-online" class="kw-btn-blue"><svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z" fill="#FF5C00"></path></svg> مشاهده </a></div></div></div></div></div><div class="col-md-4 col-lg-3"><div class="kw-p-items"><div class="kw-p-item kw-wrapper kw-wrapper-br pt-0"><div class="kw-p-image"><img src="https://karawebs.com/images/1611133098screencapture-choobiranshop-2021-01-20-12_27_03.jpg" alt="" id="ive1u"/></div><div class="kw-p-details"><div class="titles"><h3 class="kw-p-title">فروشگاه چوب ایران</h3><p class="subtitle">طراحی سایت فروشگاهی</p></div><div class="kw-p-btn"><a href="https://karawebs.com/portfolios/choobiranshop" class="kw-btn-blue"><svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z" fill="#FF5C00"></path></svg> مشاهده </a></div></div></div></div></div><div class="col-md-4 col-lg-3"><div class="kw-p-items"><div class="kw-p-item kw-wrapper kw-wrapper-br pt-0"><div class="kw-p-image"><img src="https://karawebs.com/images/1611135044screencapture-elisa-shop-ir-2021-01-20-12_59_30.jpg" alt="" id="iafqy"/></div><div class="kw-p-details"><div class="titles"><h3 class="kw-p-title">الیسا شاپ</h3><p class="subtitle">طراحی سایت فروشگاهی</p></div><div class="kw-p-btn"><a href="https://karawebs.com/portfolios/elisa-shop" class="kw-btn-blue"><svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z" fill="#FF5C00"></path></svg> مشاهده </a></div></div></div></div></div><div class="col-md-4 col-lg-3"><div class="kw-p-items"><div class="kw-p-item kw-wrapper kw-wrapper-br pt-0"><div class="kw-p-image"><img src="https://karawebs.com/images/1614420323mira.jpg" alt="" id="ig75id"/></div><div class="kw-p-details"><div class="titles"><h3 class="kw-p-title">فروشگاه میراکالا</h3><p class="subtitle">طراحی سایت فروشگاهی</p></div><div class="kw-p-btn"><a href="https://karawebs.com/portfolios/mirakala" class="kw-btn-blue"><svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z" fill="#FF5C00"></path></svg> مشاهده </a></div></div></div></div></div></div></div></section><section id="iz6v0x"><svg width="188" height="481" viewBox="0 0 188 481" fill="none" xmlns="http://www.w3.org/2000/svg" class="svg-header-right"><path fill-rule="evenodd" clip-rule="evenodd" d="M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z" fill="#288ed929" fill-opacity="0.6"></path></svg><div class="container"><div class="row"><div class="col-md-6"><img src="/backend/images/grapesjs/1624030974-panel.png" alt="" data-aos="fade-up" class="aos-init aos-animate"/></div><div class="col-md-6"><div class="section-head"><div class="section-title"><div class="title-box"><h2 class="title"> پنل مدیریت اختصاصی طراحی سایت فروشگاهی</h2><p id="ieficj">بررسی امکانات</p><div class="blue-line"></div></div></div></div><p id="i6qmdu">گروه کاراوب با استفاده از کد نویسی اختصاصی، پنل مدیریت حرفه ای را برای وب سایت فروشگاهی شما طراحی خواهد کرد و بعد از اتمام کار طراحی سایت فروشگاهی تمام جزئیات آن را در قالب یک ویدیوی آموزشی به شما آموزش خواهد داد.</p><ul class="kw-list1"><li id="i25uh8">هاست حرفه ای</li><li id="ia6iuw">امنیت پنل مدیریت</li><li id="ixmdnh">سهولت کار با پنل</li></ul></div></div></div></section><section class="what-we-do pt-5 pb-5"><div class="container"><div class="row"><div class="col-md-12"><div class="section-head justify-content-center"><div class="section-title"><div class="title-icon"><svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M40.625 45.8333C42.3479 45.8333 43.75 44.4313 43.75 42.7083V35.4167C43.75 33.6938 42.3479 32.2917 40.625 32.2917C38.1875 32.2917 35.7916 31.9083 33.5 31.1521C32.9522 30.9791 32.3677 30.9581 31.8089 31.0913C31.2501 31.2245 30.7379 31.5069 30.327 31.9083L27.327 34.9083C22.1419 32.0934 17.8834 27.8363 15.0666 22.6521L18.0416 19.6583C18.9 18.8625 19.2083 17.6521 18.8416 16.4875C18.0869 14.1923 17.7043 11.7911 17.7083 9.375C17.7083 7.65208 16.3062 6.25 14.5833 6.25H7.29163C5.56871 6.25 4.16663 7.65208 4.16663 9.375C4.16663 29.4792 20.5208 45.8333 40.625 45.8333ZM7.29163 8.33333H14.5833C14.8596 8.33333 15.1245 8.44308 15.3199 8.63843C15.5152 8.83378 15.625 9.09873 15.625 9.375C15.625 12.0354 16.0416 14.6479 16.8604 17.125C16.9205 17.3048 16.9276 17.498 16.8806 17.6817C16.8337 17.8653 16.7348 18.0316 16.5958 18.1604L12.5208 22.2563C15.9312 28.9813 20.9687 34.0188 27.725 37.4583L31.7854 33.3958C31.9239 33.2587 32.0971 33.1619 32.2865 33.1156C32.4759 33.0694 32.6742 33.0755 32.8604 33.1333C35.352 33.9583 37.9645 34.375 40.625 34.375C41.1979 34.375 41.6666 34.8438 41.6666 35.4167V42.7083C41.6666 43.2813 41.1979 43.75 40.625 43.75C21.6708 43.75 6.24996 28.3292 6.24996 9.375C6.24996 9.09873 6.35971 8.83378 6.55506 8.63843C6.75041 8.44308 7.01536 8.33333 7.29163 8.33333Z" fill="#288ED9"></path></svg></div><div class="title-box"><h2 class="title"> تماس با گروه کاراوب</h2><p>مشاوره رایگان جهت راه اندازی وب سایت...</p><div class="blue-line"></div></div></div></div></div><div class="col-md-12"><div class="d-flex justify-content-center"><div class="contact-us"><p class="contact-phone">021-77881014</p></div></div></div></div></div></section><section><svg width="188" height="481" viewBox="0 0 188 481" fill="none" xmlns="http://www.w3.org/2000/svg" class="svg-header-right"><path fill-rule="evenodd" clip-rule="evenodd" d="M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z" fill="#288ed929" fill-opacity="0.6"></path></svg><div class="container"><div class="row"><div class="col-md-6"><img src="https://karawebs.com/images/2020/sherkati/products.png" alt="" data-aos="fade-up" class="aos-init aos-animate"/></div><div class="col-md-6"><div class="section-head"><div class="section-title"><div class="title-box"><h2 class="title">اهمیت طراحی سایت فروشگاه اینترنتی</h2><p id="i19j5a">چرا طراحی سایت فروشگاهی مهم است؟</p><div class="blue-line"></div></div></div></div><p id="iextrd">با توجه به تغییر تمایل مشتری از خرید فیزیکی به خرید مجازی و اینترنتی اهمیت داشتن یک سایت فروشگاهی مشخص میشود. با داشتن یک سایت خوب، کار آمد و البته بهینه شده برای موتور های جستجو از جمله گوگل میتوانید از فرش به عرش برسید!</p><p id="i9e2ju">اما برخی هنوز هم نمیخواهند بپذیرند که سایت فروشگاهی تبدیل به یک الزام شده! اگر شما مغازه دارید، اگر با تلفن در خانه کار میکنید، اگر صاحب کارخانه هستید و… میتوانید به راحتی محصولات خود را در دنیایی پر از کاربر به نمایش و فروش بگذارید!</p><p id="ikz0qj"><strong>طراحی سایت فروشگاهی</strong> ویترین آنلاین شماست! ویترینی مدرن که به سلیقه ی شما چیده میشود. بر اساس نیاز شما و مشتریانتان ساخته میشود و میتواند شما را به قله ی موفقیت برساند. به سایت های بزرگ نگاه کنید! آمازون، <a data-cke-saved-href="http://digikala.com" href="http://digikala.com">دیجیکالا </a>و سایت های بزرگی که با فروش آنلاین هم زندگی خود را تغییر دادند هم خرید را برای کاربرانشان راحت تر کردند!</p></div></div></div></section><section id="inzibp"><svg width="174" height="481" viewBox="0 0 174 481" fill="none" xmlns="http://www.w3.org/2000/svg" class="svg-header-left"><path fill-rule="evenodd" clip-rule="evenodd" d="M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z" fill="#288ed929" fill-opacity="0.6"></path></svg><div class="container"><div id="i5l95y" class="row"><div class="col-md-6"><div class="section-head"><div class="section-title"><div class="title-box"><h3 class="title">چت آنلاین طراحی وب سایت فروشگاهی</h3><p id="iv9c94">معرفی امکانات</p><div class="blue-line"></div></div></div></div><p id="iq1y3l">این امکان بسیار جذاب در <strong>طراحی سایت فروشگاهی </strong>شما استفاده خواهد شد! به این صورت که شما عزیزان میتوانید اپلیکیشن چت را روی گوشی موبایل خود نصب کنید و با مشتریانتان در ارتباط باشید! یک سایت فروشگاهی خوب نیازمند امکانات خوب نیز هست، با استفاده از سیستم چت آنلاین شما میتوانید به مشتریانتان مشاوره دهید و به راحتی با آنها در ارتباط باشید.</p><ul class="kw-list1"><li id="iwth8k">ااپلیکیشن موبایل برای چت آنلاین</li><li id="iep7mr">دسترسی به گفتگو ها از طریق پنل مدیریت</li><li id="i9wgyp">امکان نمایش کاربران آنلاین در وب سایت شما</li></ul><a href="https://karawebs.com/portfolios" title="نمونه کارها" class="kw-btn-blue">نمونه کارها</a></div><div class="col-md-6"><img src="https://karawebs.com/images/2020/sherkati/chat.png" alt="" data-aos="fade-up" class="aos-init aos-animate"/></div></div></div></section><section id="iujubi"><svg width="188" height="481" viewBox="0 0 188 481" fill="none" xmlns="http://www.w3.org/2000/svg" class="svg-header-right"><path fill-rule="evenodd" clip-rule="evenodd" d="M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z" fill="#288ed929" fill-opacity="0.6"></path></svg><div class="container"><div class="row"><div class="col-md-6"><img src="https://karawebs.com/images/2020/sherkati/res-1.png" alt="" data-aos="fade-up" class="aos-init aos-animate"/></div><div class="col-md-6"><div class="section-head"><div class="section-title"><div class="title-box"><h3 class="title">طراحی ریسپانسیو فروشگاه اینترنتی</h3><p id="io5agx">مناسب برای تمامی نمایشگر ها</p><div class="blue-line"></div></div></div></div><p id="ieyzrg">به اطراف خود نگاه کنید، صفحه نمایش های بزرگ جی خود را به موبایل های خوش دستی داده اند که همیشه کاربران را به دنیای اینترنت متصل میکند! بر اساس الگوریتم Mobile First Index گوگل، وب سایت هایی به کاربران موبایل نمایش داده میشوند که دارای طراحی رسپانسیو باشند. برای اطلاعات بیشتر درباره ریسپانسیو میتوانید این مقاله را مطالعه کنید. اما به طور خلاصه وب سایتی ریسپانسیو است که بدون به هم ریختگی در صفحه نمایش های مختلف به کاربر نمایش داده شود. طراحی فروشگاه اینترنتی در کاراوب به صورت کاملا ریسپانسیو انجام میشود</p><p id="itcdti">امروزه سبک طراحی سایت تغییرات بسیاری کرده و اصطلاحا به Mobile First Design تغییر کرده! یعنی اول طراحی موبایل و بعد باقی صفحه نمایش ها! اهمیت طراحی فروشگاه اینترنتی به صورت ریسپانسیو به حدی بالاست که گوگل را مجبور به استفاده از الگوریتم Mobile First Index برای تمامی سایت ها کرد</p></div></div></div></section><section><svg width="174" height="481" viewBox="0 0 174 481" fill="none" xmlns="http://www.w3.org/2000/svg" class="svg-header-left"><path fill-rule="evenodd" clip-rule="evenodd" d="M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z" fill="#288ed929" fill-opacity="0.6"></path></svg><div class="container"><div class="row"><div class="col-md-6"><div class="section-head"><div class="section-title"><div class="title-box"><h2 class="title">روش های تخفیف دهی در طراحی سایت فروشگاهی</h2><p id="iug9mk">سیستم تخفیف دهی حرفه ای</p><div class="blue-line"></div></div></div></div><p id="iktdwi"> طراحی سایت فروشگاهی این امکان را به کسب و کار شما میدهد که با ایجاد سیستم های تخفیف مختلف برای مشتریانتان انگیزه ی خرید ایجاد کنید. شما میتوانید به سادگی تخفیف هایی مخصوص یک محصول، یک دسته بندی، یک یا چند کاربر و... داشته باشید.</p><p id="iyofyv">امکان ایجاد کوپن تخفیف به سادگی از طریق پنل مدیریت قالب انجام است و همچنین این موضوع در کلیپ آموزشی پنل مدیریت به شما آموزش داده میشود.</p><ul class="kw-list1"><li id="ihv4fm">تخفیف بر اساس محصول</li><li id="ianzfm">تخفیف بر اساس دسته بندی</li><li id="i21ae8">تخفیف بر اساس کاربر یا کاربران</li></ul></div><div class="col-md-6"><img src="https://karawebs.com/images/2020/pages/takhfif.png" alt="" data-aos="fade-up" class="aos-init aos-animate"/></div></div></div></section><section id="i8bp4x"><div class="container"><div data-aos="fade-up" class="contact aos-init aos-animate"><div class="wrapper"><div class="icon"></div><div class="description"><strong>به مشاوره نیاز دارید؟ همین حالا با ما تماس بگیرید</strong><p>مشاوره رایگان در رابطه با راه اندازی وب سایت شما</p></div></div><div class="call-btn"><a href="" class="kw-btn-blue">تماس با کاراوب</a></div><svg width="174" height="481" viewBox="0 0 174 481" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z" fill="#4B3DA7" fill-opacity="0.07"></path></svg></div></div></section><section id="ijoi3e"><svg width="188" height="481" viewBox="0 0 188 481" fill="none" xmlns="http://www.w3.org/2000/svg" class="svg-header-right"><path fill-rule="evenodd" clip-rule="evenodd" d="M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z" fill="#288ed929" fill-opacity="0.6"></path></svg><div class="container"><div class="row"><div class="col-md-6"><img src="https://karawebs.com/images/2020/pages/dargah.png" alt="" data-aos="fade-up" class="aos-init aos-animate"/></div><div class="col-md-6"><div class="section-head"><div class="section-title"><div class="title-box"><h3 class="title"> پرداخت آنلاین و درگاه های پرداخت</h3><p id="iuwqmf">سیستم پرداخت آنلاین در طراحی سایت فروشگاهی</p><div class="blue-line"></div></div></div></div><p id="i60pjk">یکی از نکات بسیار مهم در طراحی وب سایت فروشگاهی، امنیت آن میباشد. اگر وب سایت از امنیت کافی برخوردار نباشد، پس درگاه های پرداخت نیز به خوبی عمل نخواهند کرد و این مساله وب سایت شما را با مشکل جدی مواجه میکند. کاراوب سعی کرده تا وب سایت فروشگاهی را با بهترین کیفیت ممکن طراحی و با بالاترین امنیت به شما تحویل دهد.</p></div></div></div></section><section><svg width="174" height="481" viewBox="0 0 174 481" fill="none" xmlns="http://www.w3.org/2000/svg" class="svg-header-left"><path fill-rule="evenodd" clip-rule="evenodd" d="M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z" fill="#288ed929" fill-opacity="0.6"></path></svg><div class="container"><div class="row"><div class="col-md-6"><div class="section-head"><div class="section-title"><div class="title-box"><h3 class="title">نمایش چند مرحله ای موقعیت محصول</h3><p id="iv7pao">وضعیت سفارش محصول مشتری</p><div class="blue-line"></div></div></div></div><p id="i0dy6e">یکی از امکانات جذاب دیگری که کاراوب در طراحی سایت فروشگاهی خود اعمال میکند، امکان مشاهده وضعیت فعلی محصول از طریق پنل کاربری میباشد. این امکان جذاب به مشتری حس اعتماد بیشتری را القاء میکند</p><ul class="kw-list1"><li id="ij03xj">نمایش وضعیت فعلی سفارش</li><li id="iilqvr">تغییر وضعیت از طریق پنل مدیریت</li></ul></div><div class="col-md-6"><img src="https://karawebs.com/images/2020/pages/marhale.png" alt="" data-aos="fade-up" class="aos-init aos-animate"/></div></div></div></section>';
   $page = new \Modules\Page\Entities\Page();
   $page->title = 'پیشنویس' . rand(1,1000);
   $page->body = $content;
   $page->is_indexable = 0;
   $page->slug = \Illuminate\Support\Str::slug($page->title);
   $page->status = 0;
   $page->save();
   alert()->success('صفحه ی مورد نظر با موفقیت ساخته شد.');
    return back();
})->name('page.new');
Route::get('pages/{page}/online-editor' , 'PageController@show')->name('page.show');
Route::post('pages/{page}/update' , 'PageController@update');
Route::patch('pages/{page}/updateInfo' , 'PageController@updatePageInfo')->name('page.update');
