@component('frontend.layouts.content' , ['title' => $page->title , 'subtitle' => ''])

    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="{{route('main')}}">خانه</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{$page->title}}</li>
    @endslot

    {!! $page->body !!}



    <script type="application/ld+json">
            [{
                "@context": "https://schema.org/",
                "@type": "CreativeWorkSeason",
                "name": "{{$page->title}}",
                "aggregateRating": {
                    "@type": "AggregateRating",
                    "ratingValue": "5",
                    "ratingCount": "{{$page->rating_count}}",
                    "bestRating": "5",
                    "worstRating": "1"
            }}]

    </script>
    <input type="hidden" id="page" value="{{$page->id}}">
    @if($page->faqs->count())
        <script type="text/javascript">
            window.onload = function () {
                let page = document.getElementById('page');
                axios.get(`/pages/faqShow/${page.value}`)
                    .then(res => showResult(res));

                function showResult(res) {
                    var faqs = [];
                    for (let item of res.data) {
                        faqs.push({
                            "@type": "Question",
                            "name": `${item.question}`,
                            "acceptedAnswer": {
                                "@type": "Answer",
                                "text": `${item.answer}`
                            }
                        },)
                    }
                    $("#faqJSONLD").text(function () {
                        return JSON.stringify({
                            "@context": "https://schema.org",
                            "@type": "FAQPage",
                            "mainEntity": faqs
                        });
                    });

                }
            }


        </script>
        <script type="application/ld+json" id="faqJSONLD"></script>
    @endif
@section('head')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.21.1/axios.min.js"></script>

@stop
@section('scripts')
    <script src="{{asset('/assets/js/comments.js')}}"></script>
@stop
@endcomponent

