@component('backend.layouts.components.main',['title' => 'مدیریت سوالات متداول', 'titleBar'=>true , 'button' => 'افزودن سوال' , 'route' => 'admin.faqs.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">سوالات متداول</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست سوالات متداول</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>سوال</th>
                            <th>برای</th>
                            <th>عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($faqs as $faq)

                            <tr>
                                <td>{{$faq->question}}</td>
                                <td>
                                    {{$faq->page->title}}
                                </td>
                                <td>
                                    <form action="{{route('admin.faqs.destroy', $faq->id)}}" method="post"
                                          id="delete-{{$faq->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    <a href="{{route('admin.faqs.edit', $faq->id)}}" role="button"
                                       class="btn btn-success light sharp" title="ویرایش">
                                        <i class="fa fa-pencil"
                                           onclick="document.getElementById('edit-{{$faq->id}}').submit()"></i>
                                    </a>
                                    <button onclick="document.getElementById('delete-{{$faq->id}}').submit()"
                                            role="button" class="btn btn-danger light sharp" title="حذف">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>

                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$faqs->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
