@component('backend.layouts.components.page',['title' => 'مدیریت برگه ها', 'titleBar'=>true , 'button' => 'افزودن برگه' , 'route' => 'admin.page.new'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">برگه ها</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست برگه ها</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>نام</th>
                            <th>تاریخ ایجاد</th>
                            <th>آخرین به روز رسانی</th>
                            @can('manage-pages')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($pages as $page)

                            <tr>
                                <td>{{$page->title}}</td>
                                <td>{{\Hekmatinasser\Verta\Verta::instance($page->created_at)->formatJalaliDate()}}</td>
                                <td>{{\Hekmatinasser\Verta\Verta::instance($page->updated_at)->format('%d %B, %Y')}}</td>
                                <td>
                                    <form action="{{route('admin.pages.destroy', $page->id)}}" method="post"
                                          id="delete-{{$page->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    @can('manage-users')
                                        <a href="{{route('admin.pages.edit', $page->id)}}" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-{{$page->id}}').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-{{$page->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    @endcan
                                    <a href="{{asset($page->slug)}}" class="btn btn-primary light sharp" title="نمایش" target="_blank">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                </td>

                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$pages->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
