<?php

namespace Modules\Page\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Page\Entities\Faq;
use Modules\Page\Entities\Page;

class FaqController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()->setTitle('همه سوالات');

        $faqs = Faq::latest()->simplePaginate(15);
        return view('page::backend.faqs.all' , compact('faqs'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $this->seo()->setTitle('ایجاد سوال جدید');

        $pages = Page::all();
        return view('page::backend.faqs.create' , compact('pages'));
    }


    public function store(Request $request)
    {
        $validData = $request->validate([
           'question' => 'required',
           'answer' => 'required',
           'page_id' => 'required',
        ]);
        $faq = Faq::create($validData);
        alert()->success('عملیات موفق بود');
        return back();
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('page::show');
    }


    public function edit(Faq $faq)
    {
        $this->seo()->setTitle("ویرایش سوال $faq->question");

        $pages = Page::all();
        return view('page::backend.faqs.edit' ,compact(['faq' , 'pages']));
    }


    public function update(Request $request, Faq $faq)
    {
        $validData = $request->validate([
            'question' => 'required',
            'answer' => 'required',
            'page_id' => 'required',
        ]);
        $faq->update($validData);
        alert()->success('عملیات موفق بود');
        return back();
    }


    public function destroy(Faq $faq)
    {
        $faq->delete();
        alert()->success('عملیات موفق بود');
        return back();
    }
}
