<?php

namespace Modules\Page\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Category\Entities\Category;
use Modules\Comment\Entities\Comment;

class Page extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'body',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'meta_type',
        'status',
        'is_indexable',
        'image',
        'slug',
        'rating_count'
    ];


    //many to many polymorphic relationship whit categories table

    public function categories()
    {
        return $this->morphToMany(Category::class , 'categorizable');
    }

    public function comments()
    {
        return $this->morphMany(Comment::class , 'commentable');
    }

    public function faqs()
    {
        return $this->hasMany(Faq::class);
    }
}
