@component('backend.layouts.components.main',['title' => 'افزودن سفارش جدید','titleBar' => false])
    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">افزودن سفارش جدید</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات سفارش</h4>
            </div>
            <div class="card-body">

                    <form action="{{route('admin.orders.store')}}" method="post" id="store">
                        @csrf
                        @method('post')
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">کاربر</label>
                            <div class="col-sm-9">
                                <select class="form-control default-select" name="user_id">
                                    <option value="">انتخاب کنید</option>
                                    @foreach($users as $user)
                                        <option value="{{$user->id}}">تلفن همراه: {{$user->phone}} | نام: {{$user->name}}  </option>
                                    @endforeach
                                </select>
                                @error('user_id')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">وضعیت</label>
                            <div class="col-sm-9">
                                <select class="form-control default-select" name="status">
                                    <option value="">انتخاب کنید</option>
                                    <option value="full_paid">پرداخت شده</option>
                                    <option value="unpaid">پرداخت نشده</option>
                                    <option value="half_paid">پیش پرداخت</option>
                                    <option value="canceled">لفو شده</option>
                                </select>
                                @error('status')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">پروژه</label>
                            <div class="col-sm-9">
                                <select class="form-control default-select" name="project_id">
                                    <option value="">انتخاب کنید</option>
                                    @foreach($projects as $project)
                                        <option value="{{$project->id}}">کد: {{$project->tracking_id}} | دامنه: {{$project->domain}} </option>
                                    @endforeach
                                </select>
                                @error('project_id')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">دوره آموزشی</label>
                            <div class="col-sm-9">
                                <select class="form-control default-select" name="course_id">
                                    <option value="">انتخاب کنید</option>
                                    @foreach($courses as $course)
                                        <option value="{{$course->id}}">{{$course->title}}</option>
                                    @endforeach
                                </select>
                                @error('course_id')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">قیمت</label>
                            <div class="col-sm-9">
                                <input type="text" name="price" class="form-control input-rounded">
                                @error('price')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">نوع سفارش</label>
                            <div class="col-sm-9">
                                <select class="form-control default-select" name="type">
                                    <option value="">انتخاب کنید</option>
                                    <option value="normal">عادی</option>
                                    <option value="renewal">برای تمدید</option>
                                    <option value="first">قسط اول</option>
                                    <option value="second">قسط دوم</option>
                                </select>
                                @error('type')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>

                    </form>

            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        @if($errors->any())
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        @foreach($errors->all() as $error)
                            <p class="mb-0">{{$error}}</p>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif


        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.orders.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای ایجاد پروژه جدید، روی دکمه "ساختن" کلیک کنید.
                </p>

                <div class="row">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('store').submit()">
                            <i class="fa fa-save"></i>
                            ساختن
                        </button>
                </div>
            </div>
        </div>
    </div>
    {{-- Sidebar End --}}



    {{-- Scripts --}}
@section('script')
    <script src="/backend/vendor/nestable2/js/jquery.nestable.min.js"></script>
    <script src="{{asset('/backend/js/file-button.js')}}"></script>
@stop

@section('head')
    <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.js" integrity="sha256-H+K7U5CnXl1h5ywQfKtSj8PCmoN9aaq30gDh27Xc0jk=" crossorigin="anonymous"></script>
    <script src="https://unpkg.com/persian-date@1.1.0/dist/persian-date.min.js"></script>
    <script src="https://unpkg.com/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
    <link rel="stylesheet" href="{{ asset('/backend/vendor/nestable2/css/jquery.nestable.min.css') }}">
@stop
@endcomponent
