<?php

namespace Modules\Order\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Course\Entities\Course;
use Modules\Order\Entities\Order;
use Modules\Project\Entities\Project;
use Modules\User\Entities\User;

class OrderController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()->setTitle('همه سفارشات');

        $orders = Order::query();
        if($key = \request('search')) {
            $orders = $orders->where('tracking_id' , $key);
        }
        $orders = $orders->latest()->simplePaginate(15);
        return view('order::backend.all' , compact('orders'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $this->seo()->setTitle('ایجاد سفارش جدید');

        $users = User::all();
        $projects = Project::all();
        $courses = Course::all();
        return view('order::backend.create' , compact(['users' , 'projects' , 'courses']));
    }


    public function store(Request $request)
    {
        $validData = $request->validate([
            'user_id' => 'required',
            'status' => 'required',
            'course_id' => 'nullable',
            'project_id' => 'nullable',
            'price' => 'required',
            'type' => 'required'
        ]);
        if ($validData['course_id']) {
            $order = Order::create([
                'tracking_id' => rand(10000 , 20000),
                'status' => $validData['status'] ,
                'product_id' => $validData['course_id'],
                'product_type' => Course::class,
                'user_id' => $validData['user_id'],
                'price' => $validData['price'],
                'type' => $validData['type'],

            ]);
            $order->save();
            $order->projects()->attach($validData['project_id']);
        }
        if ($validData['project_id']) {
            $order = Order::create([
                'tracking_id' => rand(10000 , 20000),
                'status' => $validData['status'] ,
                'product_id' => $validData['project_id'],
                'product_type' => Project::class,
                'user_id' => $validData['user_id'],
                'price' => $validData['price'],
                'type' => $validData['type'],
            ]);
            $order->save();
            $order->projects()->attach($validData['project_id']);
        }
        alert()->success('سفارش با موفقیت ایجاد شد.');
        return back();
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('order::show');
    }


    public function edit(Order $order)
    {
        $this->seo()->setTitle("ویرایش سفارش $order->tracking_id");

        $users = User::all();
        $projects = Project::all();
        $courses = Course::all();
        return view('order::backend.edit' , compact(['order' , 'users' , 'projects' , 'courses' ]));
    }


    public function update(Request $request, Order $order)
    {
        $validData = $request->validate([
            'user_id' => 'required',
            'status' => 'required',
            'course_id' => 'nullable',
            'project_id' => 'nullable',
            'price' => 'required',
            'type' => 'required'

        ]);
        if (array_key_exists('course_id' , $validData)) {
            $order->update([
                'status' => $validData['status'] ,
                'product_id' => $validData['course_id'],
                'product_type' => Course::class,
                'user_id' => $validData['user_id'],
                'price' => $validData['price'],
                'type' => $validData['type'],
            ]);
        }
        if (array_key_exists('project_id' , $validData)) {
            $order->update([
                'status' => $validData['status'] ,
                'product_id' => $validData['project_id'],
                'product_type' => Project::class,
                'user_id' => $validData['user_id'],
                'price' => $validData['price'],
                'type' => $validData['type'],
            ]);
        }
        alert()->success('سفارش با موفقیت ویرایش شد.');
        return back();
    }


    public function destroy(Order $order)
    {
        $order->delete();
        alert()->success('سفارش مورد نظر با موفقیت خذف شد');
        return back();
    }
}
