<?php

namespace Modules\Order\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Course\Entities\Course;
use Modules\Payment\Entities\Payment;
use Modules\Project\Entities\Project;
use Modules\User\Entities\User;

class Order extends Model
{
    use HasFactory;

    protected $fillable = [
        'tracking_id',
        'price',
        'status',
        'project_status',
        'product_type',
        'product_id',
        'user_id',
        'type'
    ];

    public function courses()
    {
        return $this->belongsToMany(Course::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function projects()
    {
        return $this->belongsToMany(Project::class);
    }
}
