<?php

namespace Modules\Menu\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Menu\Entities\Menu;

class MenuController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()->setTitle('همه منو ها');

        $menus = Menu::with('children')
            ->whereNull('parent_id')
            ->simplePaginate(15);
        return view('menu::backend.all' , compact('menus'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $this->seo()->setTitle('ایجاد منوی جدید');

        $menus = Menu::with('children')
            ->whereNull('parent_id')
            ->simplePaginate(15);
        return view('menu::backend.create' , compact('menus'));
    }


    public function store(Request $request)
    {
        $validData = $request->validate([
           'title' => 'required',
           'parent_id' => 'nullable',
           'link' => 'required',
            'order' => 'nullable'
        ]);

        $menu = new Menu();
        $menu->title = $validData['title'];
        $menu->parent_id = $validData['parent_id'];
        $menu->order = $validData['order'];
        $menu->link = $validData['link'];
        $menu->save();
        alert()->success('منوی جدید با موفقیت ایجاد شد.');
        return back();
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('menu::show');
    }


    public function edit(Menu $menu)
    {
        $this->seo()->setTitle("ویرایش منوی $menu->title");
        $menus = Menu::with('children')
            ->whereNull('parent_id')
            ->simplePaginate(15);
        return view('menu::backend.edit' , compact(['menu','menus']));
    }


    public function update(Request $request, Menu $menu)
    {
        $validData = $request->validate([
            'title' => 'required',
            'parent_id' => 'nullable',
            'link' => 'required',
            'order' => 'nullable'
        ]);

        $selected_menu = Menu::find($validData['parent_id']);

        if ($validData['parent_id'] == $menu->id){
            alert()->error('منو نمیتواند زیر دسته ی خودش باشد' , 'خطا');
            return back();
        }
        foreach ($menu->children as $val){
            if ($validData['parent_id'] == $val->id){
                alert()->error('منو نمیتواند زیر دسته ی خودش باشد' , 'خطا');
                return back();
            }
        }
        $menu->update($validData);
        alert()->success('منو با موفقیت به روز رسانی شد');
        return back();
    }

    public function destroy(Menu $menu)
    {
        if ($menu->children()->count()){
            alert()->error('منوی مورد نظر شما دارای زیر منو است و نمیتوانید آن را حذف کنید.');
            return back();
        }
        alert()->success("منوی $menu->title با موفقیت حذف شد.");
        $menu->delete();
        return back();
    }
}
