@extends('frontend.layouts.app')
@section('head')
<script src="https://unpkg.com/@lottiefiles/lottie-player@0.4.0/dist/lottie-player.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
<meta name="robots" content="noindex">
@stop
@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
<script>
    $('.owl-carousel').owlCarousel({
        rtl:true,
        loop:true,
        margin:10,
        nav:true,
        autoplay:true,
        autoplayTimeout:3000,
        responsiveClass:true,
        autoplayHoverPause:true,
        responsive:{
            0:{
                items:1,
                nav:true
            },
            600:{
                items:3,
                nav:false
            },
            1000:{
                items:4,
                nav:true,
                loop:false
            }
        }
    })
</script>
@stop
@section('content')
<section class="header-1">
    <svg width="188" height="481" viewBox="0 0 188 481" fill="none" xmlns="http://www.w3.org/2000/svg"
         class="svg-header-right">
        <path fill-rule="evenodd" clip-rule="evenodd"
              d="M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z"
              fill="#288ed929" fill-opacity="0.6"/>
    </svg>
    <div class="container">
        <div class="row align-items-center justify-content-center">
            <div class="col-md-8 text-center">
                <h2 class="header-heading2">برای ارتقاء کسب و کار خود آماده اید؟</h2>
                <h1 class="header-heading1" style="color: #288ed9; font-size: 1.8rem">طراحی سایت فروشگاهی + اپلیکیشن فقط 5 میلیون!</h1>
                <p class="header-description">
                    گروه کاراوب یک تخفیف ویژه <strong>2.5 میلیونی</strong> برای طراحی وب سایت فروشگاهی با تمامی امکانات به همراه اپلیکیشن اندروید در نظر گرفته است. برای دریافت مشاوره و ثبت سفارش با ما تماس بگیرید.
                </p>
                <a href="tel:02177881014" class="kw-btn-blue">
                    021-77881014
                </a>
                <a href="#prices" class="kw-btn-blue">
                    تعرفه ها
                </a>
                <a href="#faqs" class="kw-btn-blue">
                    سوالات متداول
                </a>
                <a href="#portfolios" class="kw-btn-blue">
                    نمونه کار ها
                </a>
            </div>
        </div>
        <div class="row align-items-center justify-content-center">
            <div class="col-md-8">
                <lottie-player src="https://assets10.lottiefiles.com/packages/lf20_natclrl9.json"
                               background="transparent" speed="1" style="width: 100%; height: auto;" loop
                               autoplay></lottie-player>
            </div>
        </div>
    </div>

    <svg width="174" height="481" viewBox="0 0 174 481" fill="none" xmlns="http://www.w3.org/2000/svg"
         class="svg-header-left">
        <path fill-rule="evenodd" clip-rule="evenodd"
              d="M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z"
              fill="#288ed929" fill-opacity="0.6"/>
    </svg>
</section>
<section id="portfolios" class="kw-p">
    <div class="container mb-4">
        <div class="section-head">
            <div class="section-title">
                <div class="title-icon">
                    <svg width="50" height="50" viewBox="0 0 28 31" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                                d="M16.2511 4.875H17.8761V3.25C17.8761 2.81902 17.7049 2.4057 17.4002 2.10095C17.0954 1.79621 16.6821 1.625 16.2511 1.625H11.3761C10.9451 1.625 10.5318 1.79621 10.2271 2.10095C9.92233 2.4057 9.75113 2.81902 9.75113 3.25V4.875H11.3761V8.242L2.08925 24.3262C1.79293 24.8195 1.63286 25.3825 1.62539 25.9578C1.61792 26.5331 1.76333 27.1001 2.04675 27.6009C2.33016 28.1016 2.74143 28.5181 3.23854 28.8079C3.73564 29.0976 4.30075 29.2502 4.87613 29.25H22.7511C23.3265 29.2502 23.8916 29.0976 24.3887 28.8079C24.8858 28.5181 25.2971 28.1016 25.5805 27.6009C25.8639 27.1001 26.0093 26.5331 26.0019 25.9578C25.9944 25.3825 25.8343 24.8195 25.538 24.3262L16.2511 8.242V4.875ZM4.87613 30.875C3.99846 30.8752 3.13702 30.6385 2.38272 30.1898C1.62842 29.7411 1.00924 29.0971 0.590535 28.3257C0.171827 27.5544 -0.0308794 26.6843 0.00381014 25.8073C0.0384997 24.9303 0.309298 24.079 0.787625 23.3431L9.75113 7.81787V6.5C9.32015 6.5 8.90682 6.32879 8.60208 6.02405C8.29733 5.7193 8.12613 5.30598 8.12613 4.875V3.25C8.12613 2.38805 8.46854 1.5614 9.07803 0.951903C9.68752 0.34241 10.5142 0 11.3761 0H16.2511C17.1131 0 17.9397 0.34241 18.5492 0.951903C19.1587 1.5614 19.5011 2.38805 19.5011 3.25V4.875C19.5011 5.30598 19.3299 5.7193 19.0252 6.02405C18.7204 6.32879 18.3071 6.5 17.8761 6.5V7.81787L26.8396 23.3431C27.318 24.079 27.5888 24.9303 27.6234 25.8073C27.6581 26.6843 27.4554 27.5544 27.0367 28.3257C26.618 29.0971 25.9988 29.7411 25.2445 30.1898C24.4902 30.6385 23.6288 30.8752 22.7511 30.875H4.87613ZM15.1039 19.9745L17.7461 17.3323L22.7511 26H4.87613L10.8236 15.6975L15.1039 19.9745ZM15.1039 22.2722L11.173 18.343L7.69062 24.375H19.9366L17.3984 19.9777L15.1039 22.2722ZM14.6261 11.375C15.0571 11.375 15.4704 11.5462 15.7752 11.851C16.0799 12.1557 16.2511 12.569 16.2511 13C16.2511 13.431 16.0799 13.8443 15.7752 14.149C15.4704 14.4538 15.0571 14.625 14.6261 14.625C14.1951 14.625 13.7818 14.4538 13.4771 14.149C13.1723 13.8443 13.0011 13.431 13.0011 13C13.0011 12.569 13.1723 12.1557 13.4771 11.851C13.7818 11.5462 14.1951 11.375 14.6261 11.375V11.375Z"
                                fill="#288ED9"/>
                    </svg>
                </div>
                <div class="title-box">
                    <h2 class="title">
                        برخی نمونه کار های کاراوب
                    </h2>
                    <p>کیفیت، زیبایی، پشتیبانی حرفه ای...</p>
                    <div class="blue-line"></div>
                </div>

            </div>
            <a href="{{route('portfolios.all')}}" class="kw-btn-orange">
                <svg width="20" height="20" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                            d="M18.6875 29.25C25.1697 29.25 30.8068 25.636 33.6944 20.3125C32.2306 17.6087 30.0632 15.3507 27.4216 13.7774C24.7799 12.2042 21.7622 11.3741 18.6875 11.375C15.6129 11.3741 12.5951 12.2042 9.95349 13.7774C7.31183 15.3507 5.14448 17.6087 3.68066 20.3125C5.14448 23.0163 7.31183 25.2743 9.95349 26.8476C12.5951 28.4208 15.6129 29.2509 18.6875 29.25V29.25ZM18.6875 9.75C22.2031 9.74883 25.6477 10.7393 28.6256 12.6077C31.6035 14.4761 33.994 17.1466 35.5225 20.3125C33.994 23.4784 31.6035 26.1489 28.6256 28.0173C25.6477 29.8857 22.2031 30.8762 18.6875 30.875C15.172 30.8762 11.7274 29.8857 8.74949 28.0173C5.77155 26.1489 3.38103 23.4784 1.85254 20.3125C3.38103 17.1466 5.77155 14.4761 8.74949 12.6077C11.7274 10.7393 15.172 9.74883 18.6875 9.75V9.75ZM18.6875 13C20.6269 13 22.4869 13.7704 23.8583 15.1418C25.2296 16.5131 26 18.3731 26 20.3125C26 22.2519 25.2296 24.1119 23.8583 25.4832C22.4869 26.8546 20.6269 27.625 18.6875 27.625C16.7481 27.625 14.8882 26.8546 13.5168 25.4832C12.1455 24.1119 11.375 22.2519 11.375 20.3125C11.375 18.3731 12.1455 16.5131 13.5168 15.1418C14.8882 13.7704 16.7481 13 18.6875 13V13ZM18.6875 14.625C17.1791 14.625 15.7325 15.2242 14.6659 16.2908C13.5993 17.3574 13 18.8041 13 20.3125C13 21.8209 13.5993 23.2676 14.6659 24.3342C15.7325 25.4008 17.1791 26 18.6875 26C20.196 26 21.6426 25.4008 22.7092 24.3342C23.7758 23.2676 24.375 21.8209 24.375 20.3125C24.375 18.8041 23.7758 17.3574 22.7092 16.2908C21.6426 15.2242 20.196 14.625 18.6875 14.625V14.625Z"
                            fill="#FAFAFA"/>
                </svg>
                همه ی نمونه کار های
            </a>
        </div>
    </div>
    <div class="container" data-aos="fade-up">
        <div class="owl-carousel owl-theme">
            @foreach($portfolios as $portfolio)
            <div class="kw-p-items">
                <div class="kw-p-item kw-wrapper kw-wrapper-br pt-0">
                    <div class="kw-p-image">
                        <a href="{{route('portfolios.show' , $portfolio)}}">
                            <img src="{{asset($portfolio->image)}}" alt="">
                        </a>
                    </div>
                    <div class="kw-p-details">
                        <div class="titles">
                            <h3 class="kw-p-title">{{$portfolio->title}}</h3>
                            <p class="subtitle">
                                @foreach($portfolio->categories as $category)
                                {{$category->name}}
                                @endforeach
                            </p>
                        </div>
                        <div class="kw-p-btn">
                            <a href="{{$portfolio->link}}" class="kw-btn-blue">
                                <svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z" fill="#FF5C00"></path>
                                </svg>
                                مشاهده
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach

        </div>
    </div>

</section>
<section id="prices" class=" ">
    <svg width="188" height="481" viewBox="0 0 188 481" fill="none" xmlns="http://www.w3.org/2000/svg"
         class="svg-header-right">
        <path fill-rule="evenodd" clip-rule="evenodd"
              d="M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z"
              fill="#288ed929" fill-opacity="0.6"/>
    </svg>
    <div class="container">
        <div class="section-head">
            <div class="section-title">
                <div class="title-icon">
                    <svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M48.4699 1.01253C48.3248 0.651307 48.0461 0.35991 47.6917 0.198957C47.3373 0.0380044 46.9345 0.019888 46.567 0.148377C46.1996 0.276866 45.8958 0.542067 45.719 0.88881C45.5421 1.23555 45.5057 1.63714 45.6174 2.01003C47.9399 8.68503 43.3299 13.67 39.8149 16.34L38.3949 14.305C37.9174 13.6225 36.8499 13.055 36.0199 13.045L28.0499 13.08C27.0763 13.1094 26.1287 13.4014 25.3074 13.925L1.82238 30.3925C1.27611 30.7769 0.904423 31.3621 0.788689 32.02C0.672954 32.6779 0.822605 33.3548 1.20488 33.9025L11.8774 49.1725C12.6774 50.31 13.9549 50.1725 15.0949 49.3775L38.5799 32.9075C39.2549 32.43 40.0349 31.4 40.3099 30.6125L42.8049 22.75C43.0799 21.965 42.9124 20.7675 42.4349 20.085L41.5699 18.845C46.2899 15.2275 51.1899 8.83503 48.4699 1.01253V1.01253ZM37.5424 24.4075C37.1097 24.7104 36.6216 24.925 36.106 25.0392C35.5904 25.1533 35.0573 25.1648 34.5373 25.0728C34.0172 24.9809 33.5204 24.7874 33.0751 24.5033C32.6299 24.2193 32.245 23.8504 31.9424 23.4175C31.3297 22.5417 31.0896 21.4585 31.2747 20.4058C31.4599 19.353 32.0551 18.4168 32.9299 17.8025C33.6156 17.3221 34.4344 17.0679 35.2717 17.0755C36.109 17.0831 36.923 17.3522 37.5999 17.845C36.9199 18.255 36.4524 18.495 36.3649 18.5325C36.055 18.6803 35.8044 18.9289 35.6544 19.2377C35.5043 19.5465 35.4635 19.8971 35.5387 20.2321C35.614 20.5671 35.8008 20.8665 36.0685 21.0815C36.3363 21.2964 36.6691 21.414 37.0124 21.415C37.2274 21.415 37.4474 21.365 37.6549 21.2675C38.1399 21.0375 38.6599 20.765 39.2024 20.4425C39.3272 21.1927 39.2376 21.9628 38.9439 22.6643C38.6502 23.3658 38.1644 23.97 37.5424 24.4075V24.4075Z" fill="#288ED9"></path></svg>
                </div>
                <div class="title-box">
                    <h2 class="title">
                        تعرفه ها
                    </h2>
                    <p>پایینترین هزینه با کیفیت بالا...</p>
                    <div class="blue-line"></div>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-md-4">
                <div class="icon-cards">
                    <div class="icon-card bg-low-blue" data-aos="fade-up">
                        <div class="icon">
                            <img src="https://karawebs.com/backend/images/grapesjs/1624019759-online-store.png" alt="طراحی سایت شخصی" target="_blank">

                        </div>
                        <strong>طراحی سایت شخصی</strong>
                        <p>شروع از</p>
                        <strong style="font-size: 1.5rem">2.2 میلیون تومان</strong>
                        <a href="https://karawebs.com/personal-webdesign-price" class="kw-btn-blue" target="_blank">جزئیات و امکانات</a>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="icon-cards">
                    <div class="icon-card bg-low-blue" data-aos="fade-up">
                        <div class="icon">
                            <img src="https://karawebs.com/backend/images/grapesjs/1624019759-online-store.png" alt="طراحی سایت شرکتی" target="_blank">
                        </div>
                        <strong>طراحی سایت شرکتی</strong>
                        <p>شروع از</p>
                        <strong style="font-size: 1.5rem">3.2 میلیون تومان</strong>
                        <a href="https://karawebs.com/company-webdesign-price" class="kw-btn-blue" target="_blank">جزئیات و امکانات</a>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="icon-cards">
                    <div class="icon-card bg-low-blue" data-aos="fade-up">
                        <div class="icon">
                            <img src="https://karawebs.com/backend/images/grapesjs/1624019759-online-store.png" alt="طراحی سایت فروشگاهی" target="_blank">
                        </div>
                        <strong>طراحی سایت فروشگاهی</strong>
                        <strong style="color: red">تخفیف ویژه پکیج فول + اپلیکیشن اندروید به مدت محدود!</strong>
                        <strong style="font-size: 1.2rem; text-decoration: line-through">7.5 میلیون تومان</strong>
                        <strong style="font-size: 1.8rem; color: red;">5 میلیون تومان</strong>
                        <a href="https://karawebs.com/online-store-prices" class="kw-btn-blue" target="_blank">جزئیات و امکانات</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="what-we-do pt-5 pb-5  ">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="section-head justify-content-center">
                    <div class="section-title">
                        <div class="title-icon">
                            <svg width="50" height="50" viewBox="0 0 50 50" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path d="M40.625 45.8333C42.3479 45.8333 43.75 44.4313 43.75 42.7083V35.4167C43.75 33.6938 42.3479 32.2917 40.625 32.2917C38.1875 32.2917 35.7916 31.9083 33.5 31.1521C32.9522 30.9791 32.3677 30.9581 31.8089 31.0913C31.2501 31.2245 30.7379 31.5069 30.327 31.9083L27.327 34.9083C22.1419 32.0934 17.8834 27.8363 15.0666 22.6521L18.0416 19.6583C18.9 18.8625 19.2083 17.6521 18.8416 16.4875C18.0869 14.1923 17.7043 11.7911 17.7083 9.375C17.7083 7.65208 16.3062 6.25 14.5833 6.25H7.29163C5.56871 6.25 4.16663 7.65208 4.16663 9.375C4.16663 29.4792 20.5208 45.8333 40.625 45.8333ZM7.29163 8.33333H14.5833C14.8596 8.33333 15.1245 8.44308 15.3199 8.63843C15.5152 8.83378 15.625 9.09873 15.625 9.375C15.625 12.0354 16.0416 14.6479 16.8604 17.125C16.9205 17.3048 16.9276 17.498 16.8806 17.6817C16.8337 17.8653 16.7348 18.0316 16.5958 18.1604L12.5208 22.2563C15.9312 28.9813 20.9687 34.0188 27.725 37.4583L31.7854 33.3958C31.9239 33.2587 32.0971 33.1619 32.2865 33.1156C32.4759 33.0694 32.6742 33.0755 32.8604 33.1333C35.352 33.9583 37.9645 34.375 40.625 34.375C41.1979 34.375 41.6666 34.8438 41.6666 35.4167V42.7083C41.6666 43.2813 41.1979 43.75 40.625 43.75C21.6708 43.75 6.24996 28.3292 6.24996 9.375C6.24996 9.09873 6.35971 8.83378 6.55506 8.63843C6.75041 8.44308 7.01536 8.33333 7.29163 8.33333Z"
                                      fill="#288ED9"/>
                            </svg>
                        </div>
                        <div class="title-box">
                            <h2 class="title">
                                تماس با گروه کاراوب
                            </h2>
                            <p>مشاوره رایگان جهت راه اندازی وب سایت...</p>
                            <div class="blue-line"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="d-flex justify-content-center">
                    <div class="contact-us">
                        <p class="contact-phone">021-77881014</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section id="faqs" class="faq  ">
    <div class="container">
        <div class="section-head">
            <div class="section-title">
                <div class="title-icon">
                    <svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                                d="M23.9583 8.33333C21.6327 8.33347 19.3298 8.79167 17.1813 9.68178C15.0327 10.5719 13.0805 11.8765 11.4362 13.521C9.79181 15.1656 8.48746 17.1179 7.59761 19.2666C6.70775 21.4152 6.24982 23.7181 6.24996 26.0438C6.2501 28.3694 6.7083 30.6722 7.5984 32.8208C8.48851 34.9693 9.79309 36.9215 11.4377 38.5659C13.0822 40.2102 15.0346 41.5146 17.1832 42.4044C19.3319 43.2943 21.6347 43.7522 23.9604 43.7521C28.6572 43.7518 33.1615 41.8857 36.4825 38.5644C39.8034 35.243 41.669 30.7385 41.6687 26.0417C41.6684 21.3448 39.8024 16.8405 36.481 13.5196C33.1597 10.1986 28.6551 8.33306 23.9583 8.33333V8.33333ZM23.9583 6.25C29.2074 6.25 34.2415 8.33519 37.9531 12.0468C41.6648 15.7585 43.75 20.7926 43.75 26.0417C43.75 31.2907 41.6648 36.3248 37.9531 40.0365C34.2415 43.7481 29.2074 45.8333 23.9583 45.8333C18.7092 45.8333 13.6751 43.7481 9.96347 40.0365C6.25181 36.3248 4.16663 31.2907 4.16663 26.0417C4.16663 20.7926 6.25181 15.7585 9.96347 12.0468C13.6751 8.33519 18.7092 6.25 23.9583 6.25V6.25ZM22.9166 35.4167H25V39.5833H22.9166V35.4167ZM23.9583 12.5C25.8922 12.5 27.7468 13.2682 29.1143 14.6357C30.4817 16.0031 31.25 17.8578 31.25 19.7917C31.25 21.6604 29.7937 22.9563 28.252 24.325L26.3041 26.2063C25.0791 27.6104 24.9458 30.2792 24.9979 31.1896V31.25H22.9166C22.9083 31.1417 22.7041 27.1583 24.7375 24.8354L26.8666 22.7688C28.1 21.6729 29.1666 20.725 29.1666 19.7917C29.1666 18.4103 28.6179 17.0856 27.6411 16.1088C26.6644 15.1321 25.3396 14.5833 23.9583 14.5833C22.577 14.5833 21.2522 15.1321 20.2754 16.1088C19.2987 17.0856 18.75 18.4103 18.75 19.7917H16.6666C16.6666 17.8578 17.4349 16.0031 18.8023 14.6357C20.1698 13.2682 22.0244 12.5 23.9583 12.5Z"
                                fill="black"/>
                    </svg>
                </div>
                <div class="title-box">
                    <h2 class="title">
                        سوالات متداول
                    </h2>
                    <p>پر تکرارترین سوالات...</p>
                    <div class="blue-line"></div>
                </div>
            </div>
        </div>
        <div class="row mt-3">
            <ul class="nav nav-tabs" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <a class="nav-link active" id="home-tab" data-toggle="tab" href="#webdevelopment" role="tab"
                       aria-controls="home" aria-selected="true">طراحی سایت</a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link" id="profile-tab" data-toggle="tab" href="#coding" role="tab"
                       aria-controls="profile" aria-selected="false">طراحی سایت اختصاصی</a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link" id="contact-tab" data-toggle="tab" href="#wordpress" role="tab"
                       aria-controls="contact" aria-selected="false">طراحی سایت با وردپرس</a>
                </li>
            </ul>
            <div class="container">
                <div class="tab-content mt-3" id="myTabContent">
                    <div class="tab-pane fade show active" id="webdevelopment" role="tabpanel"
                         aria-labelledby="home-tab">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="accordion">
                                    <div class="accordion__item">
                                        <h4 class="accordion__title active">طراحی سایت چیست؟</h4>
                                        <div class="accordion__body">
                                            <p>هر وب سایت یک نرم افزار تحت وب است که روی یک فضای میزبانی (هاست)
                                                پیاده سازی میشود. طراحی سایت انواع مختلفی مانند طراحی سایت داینامیک،
                                                طراحی سایت اختصاصی، طراحی سایت وردپرس، طراحی سایت فروشگاهی، طراحی
                                                سایت شرکتی و... میباشد</p>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title">چرا طراحی سایت مهم است؟</h4>
                                        <div class="accordion__body">
                                            <p>
                                                امروزه داشتن یک وب سایت به یک الزام برای هر کسب و کاری تبدیل شده، با
                                                پیشرفت تکنولوژی تقریبا کسب و کار های سنتی جای خود را به وب سایت ها و
                                                اپلیکیشن ها داده اند
                                            </p>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title"> تفاوت طراحی سایت اختصاصی و وردپرس چیست؟</h4>
                                        <div class="accordion__body">
                                            <p>
                                                طراحی سایت اختصاصی و طراحی سایت وردپرس تفاوت های بسیار زیادی با هم
                                                دارند. طراحی سایت با وردپرس معمولا از قالب های آماده استفادهه میشود
                                                در حالی که در طراحی سایت اختصاصی همه چیز از صفر تا صد برای شما طراحی
                                                خواهد شد
                                            </p>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title"> انواع زبان های طراحی سایت کدام هستند؟ </h4>
                                        <div class="accordion__body">
                                            <p>طراحی سایت با زبان های گوناگونی انجام میشود. برای ظاهر وب سایت معمولا
                                                از HTML و CSS و زبان javascript استفاده میشود. برای قسمت بک اند
                                                (سرور) که پردازش های یک سایت داینامیک را انجام میدهد میتوان از زبان
                                                های مختلفی استفاده کرد مانند: PHP، Python، Node.js و...</p>
                                            <hr>
                                            <ul>
                                                <li>طراحی سایت با زبان PHP ( طراحی سایت با زبان پی اچ پی )</li>
                                                <li>طراحی سایت با زبان Python ( طراحی سایت با زبان پایتون )</li>
                                                <li>طراحی سایت با زبان Asp ( طراحی سایت با زبان ای اس پی )</li>
                                                <li>طراحی سایت با زبان go ( طراحی سایت با زبان گو )</li>
                                                <li>طراحی سایت با Django ( طراحی سایت با زبان جنگو )</li>
                                                <li>طراحی سایت با زبان C# ( طراحی سایت با زبان سی شارپ )</li>
                                            </ul>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title"> طراحی سایت ریسپانسیو چیست؟ </h4>
                                        <div class="accordion__body">
                                            <p>در گذشته طراحی وب سایت به گونه ای انجام میشد که اغلب برای نسخه دسکتاپ
                                                بود، با افزایش کاربران موبایل هوشمند، در طراحی سایت هم انقلابی به
                                                شد، تا جایی که امروزه ابتدا وب سایت برای موبایل طراحی شده و در مرحله
                                                بعد برای نسخه دستکتاپ طراحی میگردد. طراحی سایت ریسپانسیو یعنی
                                                سازگاری وب سایت در انواع صفحه نمایش از کوچک تا بزرگ
                                            </p>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title"> انواع طراحی وب سایت در کاراوب کدامند؟ </h4>
                                        <div class="accordion__body">
                                            <p>گروه طراحی سایت کاراوب دارای نمونه کار های بسیار زیادی است که بخشی از
                                                آنها را میتوانید از طریق این صفحه مشاهده کنید.</p>
                                            <hr>
                                            <ul>
                                                <li><a href="https://karawebs.com/online-store-web-design">طراحی
                                                    سایت فروشگاهی</a></li>
                                                <li><a href="https://karawebs.com/companywebdesign">طارحی سایت
                                                    شرکتی</a></li>
                                                <li><a href="https://karawebs.com/dr-webdesign">طراحی سایت پزشکی</a>
                                                </li>
                                                <li><a href="https://karawebs.com/amlak">طراحی سایت آژانس املاک</a>
                                                </li>
                                                <li>طراحی سایت شخصی</li>
                                                <li>طراحی سایت آگهی و دایرکتوری</li>
                                                <li>طراحی سایت معماری</li>
                                                <li>طراحی سایت فروش فایل</li>
                                                <li>طراحی سایت آموزشی</li>
                                                <li>طراحی سایت سفارش آنلاین غذا</li>
                                                <li>طراحی سایت چند فروشندگی</li>
                                                <li>طراحی سایت کتابفروشی</li>
                                                <li>طراحی سایت فروش موبایل</li>
                                                <li>طراحی سایت آژانس مسافربری</li>
                                                <li>طراحی سایت خبری</li>
                                            </ul>
                                        </div>
                                        <!-- 	END Item -->
                                    </div>
                                    <!-- 	END Accordion -->
                                </div>
                                <!-- 	END Accordion -->
                            </div>
                            <div class="col-md-6">
                                <div class="accordion">
                                    <div class="accordion__item">
                                        <h4 class="accordion__title"> انواع نرم افزار های طراحی ظاهر سایت
                                            کدامند؟ </h4>
                                        <div class="accordion__body">
                                            <p>محبوب ترین این نرم افزار های طراحی ظاهری (UI) فتوشاپ و Adobe XD
                                                میباشند</p></div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title"> یک طراح سایت خوب چه کسی است؟ </h4>
                                        <div class="accordion__body">
                                            <p>برای پاسخ به این سوال باید جوانب بسیار زیادی را در نظر گرفت اما
                                                معمولا نمونه کار های شرکت یا گروه طراحی سایت یا شخصی که میخواهید با
                                                او کار کنید، نشان دهنده ی سطح کاری طراح میباشد</p></div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title"> بهترین زبان برنامه نویسی برای طراحی سایت
                                            چیست؟ </h4>
                                        <div class="accordion__body">
                                            <p>این سوال شاید جواب دقیق نداشته باشد! زیرا اکثر زبان های بنامه نویسی
                                                محبوب مانند Python و PHP بسته به نوع برنامه نویسی میتوانند نیاز ها و
                                                امکانات سایت شما را تکمیل کنند</p></div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title"> نمونه کار های طراحی سایت کاراوب را کجا میتوانم
                                            ببینم؟ </h4>
                                        <div class="accordion__body">
                                            <p>گروه طراحی سایت کاراوب دارای نمونه کار های بسیار زیادی است که بخشی از
                                                آنها را میتوانید از طریق این صفحه مشاهده کنید.</p>
                                            <br>
                                            <a href="{{route('portfolios.all')}}">نمونه کار های طراحی وب سایت</a>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="coding" role="tabpanel"
                         aria-labelledby="profile-tab">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="accordion">
                                    <div class="accordion__item">
                                        <h4 class="accordion__title active">طراحی سایت اختصاصی چیست؟ </h4>
                                        <div class="accordion__body">
                                            <p>در این نوع طراحی سایت ، همه چیز از صفر تا صد برای شما طراحی میشود. ظاهر و باطن به صورت اختصاصی! از هیچ سیستم مدیریت محتوای آماده ای مانند وردپرس و جوملا در طراحی سایت اختصاصی استفاده نخواهد شد.
                                            </p>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title">پنل مدیریت طراحی سایت اختصاصی به چه صورت است؟ </h4>
                                        <div class="accordion__body">
                                            <p>پنل مدیریت طراحی سایت اختصیاصی با توجه به امکانات وب سایت شما طراحی و کدنویسی میشود، طراحی سایت اختصاصی دارای پنل مدیریت ساده و راحت تری نسبت به طراحی سایت وردپرس میباشد.</p>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title">قالب اختصاصی چیست؟ </h4>
                                        <div class="accordion__body">
                                            <p>اگر میخواهید وب سایت نظیر وب سایت شما وجود نداشته باشد میتوانید طراحی سایت با قالب اختصاصی سفارش دهید. قالب اختصاصی از صفر تا صد مناسب کسب و کار شما طراحی شده و مانند آن در هیچ وب سایتی وجود نخواهد داشت</p>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title">طراحی سایت اختصاصی با چه زبان برنامه نویسی ای انجام میشود؟ </h4>
                                        <div class="accordion__body">
                                            <p>طراحی سایت با زبان های گوناگونی انجام میشود. برای ظاهر وب سایت معمولا از HTML و CSS و زبان javascript استفاده میشود. برای قسمت بک اند (سرور) که پردازش های یک سایت داینامیک را انجام میدهد میتوان از زبان های مختلفی استفاده کرد مانند: PHP، Python، Node.js و...</p>
                                            <hr>
                                            <ul>
                                                <li>طراحی سایت با زبان PHP ( طراحی سایت با زبان پی اچ پی )</li>
                                                <li>طراحی سایت با زبان Python ( طراحی سایت با زبان پایتون )</li>
                                                <li>طراحی سایت با زبان Asp ( طراحی سایت با زبان ای اس پی )</li>
                                                <li>طراحی سایت با زبان go ( طراحی سایت با زبان گو )</li>
                                                <li>طراحی سایت با Django ( طراحی سایت با زبان جنگو )</li>
                                                <li>طراحی سایت با زبان C# ( طراحی سایت با زبان سی شارپ )</li>
                                            </ul>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                </div>
                                <!-- 	END Accordion -->
                            </div>
                            <div class="col-md-6">
                                <div class="accordion">
                                    <div class="accordion__item">
                                        <h4 class="accordion__title">آیا طراحی سایت اختصاصی از طراحی سایت با ورپرس بهتر است؟ </h4>
                                        <div class="accordion__body">
                                            <p>اگر وب سایت شما خارج از امکانات و چارچوب وردپرس باشد، آنگاه طراحی سایت اختصاصی به کار شما خواهد آمد در غیر این صورت میتوانید با هزینه کمتر طراحی سایت وردپرسی را سفارش دهید</p>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title">هزینه طراحی سایت اختصاصی چقدر است؟ </h4>
                                        <div class="accordion__body">
                                            <p>هزینه طراحی سایت اختصاصی بر اساس ماژول ها و امکانات وب سایت برآورد میشود، برای مثال، طراحی سایت شرکتی و طراحی سایت فروشگاهی تفاوت قیمت زیای با هم دارند.</p>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title">چرا طراحی سایت اختصاصی گرانتر است؟ </h4>
                                        <div class="accordion__body">
                                            <p>در طراحی سایت اختصاصی به دلیل این که از هیچ سیستم آماده ای استفاده نخواهد شد، هزینه بالاتری نسبت به طراحی سایت با وردپرس دارد</p>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                </div>
                                <!-- 	END Accordion -->
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="wordpress" role="tabpanel"
                         aria-labelledby="contact-tab">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="accordion">
                                    <div class="accordion__item">
                                        <h4 class="accordion__title active">طراحی سایت وردپرس چیست؟ </h4>
                                        <div class="accordion__body">
                                            <p>وردپرس یک سیستم مدیریت محتوای بسیار قدرتمند است که به طراحان سایت این امکان را میدهد تا بیشتر تمرکز خود را روی ظاهر سایت بگذارند

                                            </p>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title"> طراحی سایت وردپرسی خوب است؟ </h4>
                                        <div class="accordion__body">
                                            <p>بیش از 80.000.000 میلیون وب سایت از سیستم وردپرس برای طراحی سایت استفاده میکنند. وب سایت های برند های بزرگی مانند بنز و بی ام دبلیو طراحی سایت با وردپرس نیاز اکثر کاربران را رفع میکند، البته طراحی سایت وردپرسی مستلزم تخصص و دانش در این زمینه میباشد.

                                            </p>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title">آیا طراحی سایت وردپرس امن است؟ </h4>
                                        <div class="accordion__body">
                                            <p>وردپرس بر خلاف تصور برخی مردم سیستم امن و خوبی است، به طوریکه بسیاری از فروشگاه های بزرگ که روزانه اطلاعات و پول زیادی در آن رد و بدل میشوند از وردپرس استفاده میکنند

                                            </p>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                    <div class="accordion__item">
                                        <h4 class="accordion__title">انواع طراحی سایت وردپرس چیست؟ </h4>
                                        <div class="accordion__body">
                                            <p>طراحی سایت اب وردپرس انواع مختلفی دارد که به آن اشاره میکنیم:</p>
                                            <hr>
                                            <ul>
                                                <li><a href="../../online-store-web-design">طراحی سایت فروشگاهی</a></li>
                                                <li><a href="../../companywebdesign">طارحی سایت شرکتی</a></li>
                                                <li><a href="../../dr-webdesign">طراحی سایت پزشکی</a></li>
                                                <li><a href="../../amlak">طراحی سایت آژانس املاک</a></li>
                                                <li>طراحی سایت شخصی</li>
                                                <li>طراحی سایت آگهی و دایرکتوری</li>
                                                <li>طراحی سایت معماری</li>
                                                <li>طراحی سایت فروش فایل</li>
                                                <li>طراحی سایت آموزشی</li>
                                                <li>طراحی سایت سفارش آنلاین غذا</li>
                                                <li>طراحی سایت چند فروشندگی</li>
                                                <li>طراحی سایت کتابفروشی</li>
                                                <li>طراحی سایت فروش موبایل</li>
                                                <li>طراحی سایت آژانس مسافربری</li>
                                                <li>طراحی سایت خبری</li>
                                            </ul>
                                        </div>
                                    </div>
                                    <!-- 	END Item -->
                                </div>
                                <!-- 	END Accordion -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>
@stop