<?php

namespace Modules\Main\Http\Controllers\Front;

use Artesaos\SEOTools\Facades\OpenGraph;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Traits\SEOTools;
use Modules\Portfolio\Entities\Portfolio;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class MainController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()
            ->setTitle('بازاریابی - مارکتینگ');
        $this->seo()->jsonLd()->setType('WebPage');
        $this->seo()->jsonLd()->setImages(asset('https://karawebs.com/images/2020/Main/laptop-header%20(1).png'));
        $this->seo()->jsonLd()->setUrl(asset('https://karawebs.com'));
        SEOMeta::addKeyword('طراحی سایت , طراحی سایت در تهران , طراحی وب سایت , طراحی سایت تهران , طراحی سایت حرفه ای , طراحی وب سایت حرفه ای , طراحی وبسایت , طراحی سایت اختصاصی , طراحی سایت با وردپرس')
            ->setCanonical(asset('https://karawebs.com'));
        OpenGraph::setTitle('طراحی سایت | طراحی سایت تهران | طراحی وب سایت تهران | طراحی وب سایت')
            ->setDescription('اگر میخواهید طراحی سایت انجام دهید، باید چند نکته را درنظر بگیرید. قیمت، کیفیت کد نویسی، سئو، پشتیبانی و... گروه کاراوب با بیش از 10 سال تجربه در زمینه های طراحی وب سایت ، توسعه و طراحی اپلیکیشن')
            ->setUrl(asset('https://karawebs.com'))
            ->addProperty('locale', 'fa_IR')
            ->setSiteName('کاراوب')
            ->setType('Article');
        return view('welcome');
    }

    public function landing()
    {
        $this->seo()
            ->setTitle('طراحی سایت | طراحی سایت تهران | طراحی وب سایت')
            ->setDescription('طراحی سایت با بهترین کیفیت و بهترین هزینه را در کاراوب تجربه کنید. گروه طراحی وب سایت کاراوب با بیش از 10 سال تجربه در این زمینه آماده ی خدمت رسانی به شما میباشد.');
        $portfolios = Portfolio::with('categories')->where('status' , 1)->orderBy('order_id')->get();
        return view('main::landing' , compact('portfolios'));
    }
}
