<?php

namespace Modules\Main\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Nwidart\Modules\Facades\Module;

class MainController extends Controller
{
    use SEOTools;
    public function __construct()
    {
        $this->middleware('can:manage-plugins');
    }

    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $this->seo()->setTitle('همه ماژول ها');
        $modules = Module::all();
        return view('main::backend.modules.all', compact('modules'));
    }

    public function enable($module)
    {
        $module = Module::find($module);
        $module->enable();
        alert()->success('پلاگین با موفقیت فعال شد.','موفق');
        return back();
    }

    public function disable($module)
    {
        $module = Module::find($module);
        $module->disable();
        alert()->success('پلاگین با موفقیت غیرفعال شد.','موفق');
        return back();
    }

}
