<?php

namespace Modules\File\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Modules\Category\Entities\Category;
use Modules\File\Entities\File;
use Modules\Post\Entities\Post;

class FileController extends Controller
{
    use SEOTools;
    public function __construct()
    {
        $this->middleware('can:manage-posts');
    }
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $this->seo()->setTitle('همه فایل ها');

        $files = File::query();
        if ($key = \request('search')) {
            $files = $files->where('title', 'like', "%$key%");
        }
        $files = $files->latest()->simplePaginate(15);
        return view('file::backend.all', compact('files'));
    }


    public function create()
    {
        $this->seo()->setTitle('ایجاد فایل جدید');

        return view('file::backend.create');
    }


    public function store(Request $request)
    {
        try {
            $validData = $request->validate([
                'title' => 'required'
            ]);
            $file = new File();
            $file->title = $validData['title'];

            $file->file = $request->file;
            $file->save();

            alert()->success('فایل با موفقیت ایجاد شد', 'موفق');
            return back();
        } catch (\Illuminate\Database\QueryException $e) {
            $errorCode = $e->errorInfo[1];
            if ($errorCode == '1062') {
                alert()->error('لینک مورد نظر قبلا در سیستم ثبت شده است', 'خطا');
                return back();
            }
        }

    }


    public function show($id)
    {
        return view('file::show');
    }

    public function edit(File $file)
    {
        $this->seo()->setTitle("ویرایش فایل $file->title");
        return view('file::backend.edit' , compact('file'));
    }


    public function update(Request $request, File $file)
    {
        $validData = $request->validate([
            'title' => 'required',
            'file' => 'required'
        ]);
        //if status exists
        $file->update($validData);
        alert()->success('فایل با موفقیت ویرایش شد', 'موفق');
        return back();
    }


    public function destroy(File $file)
    {
        $file->delete();
        alert()->success(" فایل  $file->title با موفقیت حذف شد." , 'موفق');
        return redirect(route('admin.files.index'));
    }
}
