<?php

namespace Modules\Discount\Http\Controllers\Front;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Cart\Http\Helpers\Cart;
use Modules\Discount\Entities\Discount;

class DiscountController extends Controller
{
    public function check(Request $request)
    {
        $validData = $request->validate([
            'discount' => 'required|exists:discounts,code'
        ]);
        if (!auth()->check()) {
            return back()->withErrors([
                'discount' => 'برای اعمال کد تخفیف لطفا وارد وب سایت شوید'
            ]);
        }

        $discount = Discount::whereCode($validData['discount'])->first();

        if ($discount->status == 0) {
            return back()->withErrors([
                'discount' => 'کد تخفیف مورد نظر قابل استفاده نیست.'
            ]);
        }

        if ($discount->expires_at < now()) {
            return back()->withErrors([
                'discount' => 'کد تخفیف مورد نظر منقضی شده است.'
            ]);
        }
        if ($discount->user_id) {
            if (auth()->user()->id != $discount->user_id) {
                return back()->withErrors([
                    'discount' => 'شما قادر به استفاده از این کد تخفیف نیستید.'
                ]);
            }
        }
        $cart = Cart::instance('cart');
        $cart->addDiscount($discount->id);

        return back();
    }

    public function destroy()
    {
        $cart = Cart::instance('cart');
        $cart->addDiscount(null);
        alert()->success('کد تخفیف با موفقیت حذف گردید.' , 'موفق');
        return back();
    }
}
