<?php

namespace Modules\Discount\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Hekmatinasser\Verta\Verta;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Course\Entities\Course;
use Modules\Discount\Entities\Discount;
use Modules\User\Entities\User;

class DiscountController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()->setTitle('همه تخفیف ها');

        $discounts = Discount::query();
        if ($key = \request('search')) {
            $discounts = $discounts->where('code' , 'like' , "%$key%");
        }
        $discounts = $discounts->latest()->simplePaginate(15);
        $courses = Course::all();
        $users = User::all();
        return view('discount::backend.all' , compact(['discounts' , 'users' , 'courses']));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $this->seo()->setTitle('ایجاد کد تخفیف جدید');

        $courses = Course::all();
        $users = User::all();
        return view('discount::backend.create'  , compact([ 'users' , 'courses']));
    }

    public function store(Request $request)
    {
        $validData = $request->validate([
            'code' => 'required',
            'percent' => 'required',
            'course_id' => 'nullable',
            'user_id' => 'nullable',
            'expires_at' => 'required',
            'status' => 'nullable'
        ]);
        $string = explode('/', $validData['expires_at']) ;
        $year = persianToEngNum($string[0]);
        $month = persianToEngNum($string[1]);
        $day = persianToEngNum($string[2]);
        $date = Verta::getGregorian($year,$month,$day);
        $Gdate = implode('-',$date) . ' ' . '14:40:47';
        $discount = new Discount();
        $discount->code = $validData['code'];
        $discount->percent = $validData['percent'];
        $discount->course_id = $validData['course_id'];
        $discount->user_id = $validData['user_id'];
        $discount->expires_at = $Gdate;
        if (array_key_exists('status', $validData)) {
            $validData['status'] = 1;
            $discount->status = $validData['status'];
        } else {
            $discount->status = 0;
        }
        $discount->save();
        alert()->success('کد تخفیف با موفقیت ساخته شد.');
        return back();
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('discount::show');
    }


    public function edit(Discount $discount)
    {
        $this->seo()->setTitle("ویرایش کد تخفیف $discount->code");

        $courses = Course::all();
        $users = User::all();
        return view('discount::backend.edit'  , compact([ 'users' , 'courses' , 'discount']));
    }

    public function update(Request $request, Discount $discount)
    {
        $validData = $request->validate([
            'code' => 'required',
            'percent' => 'required',
            'course_id' => 'nullable',
            'user_id' => 'nullable',
            'expires_at' => 'required',
            'status' => 'nullable'
        ]);
        $string = explode('/', $validData['expires_at']) ;
        $year = persianToEngNum($string[0]);
        $month = persianToEngNum($string[1]);
        $day = persianToEngNum($string[2]);
        $date = Verta::getGregorian($year,$month,$day);
        $Gdate = implode('-',$date) . ' ' . '14:40:47';
        //if status exists
        if (array_key_exists('status', $validData)) {
            $validData['status'] = 1;
            $discount->update([
                'code' => $validData['code'],
                'percent' => $validData['percent'],
                'course_id' => $validData['course_id'],
                'user_id' => $validData['user_id'],
                'expires_at' => $Gdate,
                'status' => $validData['status']
            ]);
        }else {
            $discount->update([
                'code' => $validData['code'],
                'percent' => $validData['percent'],
                'course_id' => $validData['course_id'],
                'user_id' => $validData['user_id'],
                'expires_at' => $Gdate,
                'status' => 0
            ]);
        }

        alert()->success('کد تخفیف با موفقیت به روز شد.');
        return back();
    }

    public function destroy(Discount $discount)
    {
        $discount->delete();
        alert()->success('کد تخفیف با موفقیت حذف شد.');
        return back();
    }
}
