<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;

Route::prefix('series')->group(function (){
    Route::get('all', 'Front\CourseController@index')->name('courses.all');
    Route::get('{course:slug}', 'Front\CourseController@show')->name('courses.show');
    Route::middleware('auth')->group(function (){
        Route::post('register/{course}' , 'Front\CourseController@register')->name('course.register');
    });
    Route::get('{course:slug}/{episode:slug}', 'Front\EpisodeController@show')->name('episode.show');
    Route::middleware(['auth' , 'signed'])->group(function () {
        Route::get('/' , 'Front\EpisodeController@getUrl')->name('get.episode.url');
        Route::post('/download' , 'Front\EpisodeController@download')->name('get.episode.download');
    });
});
Route::prefix('profile')->middleware('auth')->group(function (){
    Route::get('courses' , 'Front\CourseController@profileCourses')->name('profile.courses');
});
