@component('frontend.layouts.content' , ['title' => $episode->title , 'subtitle' => 'لذت یادگیری با کاراوب...'])

    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="{{route('main')}}">خانه</a></li>
        <li class="breadcrumb-item"><a href="{{route('courses.all')}}">آکادمی</a></li>
        <li class="breadcrumb-item " aria-current="page"><a
                href="{{asset('series/' . $course->slug)}}">{{$course->title}}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{$episode->title}}</li>
    @endslot
@section('head')
    <script type="application/ld+json">
    [
        {
        "@context": "https://schema.org/",
        "@type": "Course",
        "name": "{{$episode->title}}",
        "aggregateRating": {
            "@type": "AggregateRating",
            "ratingValue": "5",
            "ratingCount": "{{$episode->rating_count}}",
            "bestRating": "5",
            "worstRating": "1"
          }
        }
    ]

    </script>
@stop
<div class="float-sidebar">
    <a id="details">جزئیات</a>
</div>
<section>
    <div class="container">
        <div class="row mt-5">
            <div class="col-md-12 col-lg-9">
                <!--details-->
                <div class="kw-wrapper kw-wrapper-br p-4">
                    @auth
                        @if(!$episode->is_free)
                            @if($course->users->where('id' , auth()->user()->id)->count())
                                <video class="video-player" poster="{{$course->video_cover}}" controls>
                                    <source
                                        src="{{\Illuminate\Support\Facades\URL::temporarySignedRoute('get.episode.url' ,now()->addMinutes(40), ['path' => "$episode->video"])}}"
                                        type="video/mp4">
                                </video>
                                @else
                                <div class="guest-box position-relative">
                                    <div class="guest-banner bg-no-repeat bg-cover kw-wrapper-br"
                                         style="background-image: url({{$course->video_cover}});">

                                    </div>
                                    <p class="guest-message text-white">برای مشاهده این قسمت باید در دوره ثبت نام کنید.</p>
                                    <div class="guest-overlay position-absolute"></div>
                                </div>
                            @endif
                        @else
                            <video class="video-player" poster="{{$course->video_cover}}" controls>
                                <source
                                    src="{{\Illuminate\Support\Facades\URL::temporarySignedRoute('get.episode.url' , now()->addMinutes(40) , ['path' => "$episode->video"])}}"
                                    type="video/mp4">
                            </video>
                        @endif
                    @endauth
                    @guest
                        @if(!$episode->is_free)
                                <div class="guest-box position-relative">
                                    <div class="guest-banner bg-no-repeat bg-cover kw-wrapper-br"
                                         style="background-image: url({{$course->video_cover}});">

                                    </div>
                                    <p class="guest-message text-white">برای مشاهده این قسمت باید در دوره ثبت نام کنید.</p>
                                    <div class="guest-overlay position-absolute"></div>
                                </div>
                        @else
                                <div class="guest-box position-relative">
                                    <div class="guest-banner bg-no-repeat bg-cover kw-wrapper-br"
                                         style="background-image: url({{$course->video_cover}});">
                                    </div>
                                    <p class="guest-message text-white">برای مشاهده این ویدئو باید <a href="{{route('login')}}">وارد</a>
                                        سایت شوید، یا اگر عضو کاراوب نیستید لطفا
                                        <a href="{{route('register')}}">ثبت نام</a> کنید.</p>
                                    <div class="guest-overlay position-absolute"></div>
                                </div>
                        @endif

                    @endguest
                    <div class="text-container gradient position-relative p-4">
                        {!! $episode->body !!}
                        <button class="show-btn kw-btn-blue">ادامه مطلب</button>
                    </div>
                </div>
                <!--episodes-->
            @include('course::frontend.partials.episodes' , ['course' => $course ])
            <!--episodes end-->
            @auth
                <!--send comment-->
                    <div class="kw-wrapper kw-wrapper-br mt-3" id="addcomment">
                        <div class="section-head p-3">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="39" height="39" viewBox="0 0 39 39" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M4.875 33.4523L10.7023 27.625H29.25C30.112 27.625 30.9386 27.2826 31.5481 26.6731C32.1576 26.0636 32.5 25.237 32.5 24.375V9.75C32.5 8.88805 32.1576 8.0614 31.5481 7.4519C30.9386 6.84241 30.112 6.5 29.25 6.5H8.125C7.26305 6.5 6.4364 6.84241 5.8269 7.4519C5.21741 8.0614 4.875 8.88805 4.875 9.75V33.4523ZM4.875 35.75H3.25V9.75C3.25 8.45707 3.76361 7.21709 4.67785 6.30285C5.59209 5.38861 6.83207 4.875 8.125 4.875H29.25C30.5429 4.875 31.7829 5.38861 32.6971 6.30285C33.6114 7.21709 34.125 8.45707 34.125 9.75V24.375C34.125 25.6679 33.6114 26.9079 32.6971 27.8221C31.7829 28.7364 30.5429 29.25 29.25 29.25H11.375L4.875 35.75ZM9.75 11.375H27.625V13H9.75V11.375ZM9.75 16.25H27.625V17.875H9.75V16.25ZM9.75 21.125H22.75V22.75H9.75V21.125Z"
                                            fill="#288ED9"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <h2 class="title">
                                        ثبت نظر برای این دوره
                                    </h2>
                                    <p>ثبت نظر جدید...</p>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>

                        <form action="" class="mt-0" id="comment-store" method="post">
                            @csrf
                            @method('post')
                            <input type="hidden" id="commentable_id" value="{{$episode->id}}">
                            <input type="hidden" id="commentable_type" value="{{get_class($episode)}}">
                            <label for="body">نظر شما</label>
                            <textarea name="message" id="body" cols="30" rows="10" class="form-control"></textarea>
                            <a class="kw-btn-green" onclick="sendComment()">ارسال نظر</a>
                        </form>
                    </div>
                @endauth
                @guest
                    <div class="alert alert-info mt-3 kw-wrapper-br" role="alert">
                        برای ثبت نظر ابتدا باید ثبت نام کنید.
                    </div>
            @endguest
            <!--comments-->
                <div class="comments mt-3 kw-wrapper kw-wrapper-br p-3">
                    <div class="section-head p-3">
                        <div class="section-title">
                            <div class="title-icon">
                                <svg width="39" height="39" viewBox="0 0 39 39" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M4.875 33.4523L10.7023 27.625H29.25C30.112 27.625 30.9386 27.2826 31.5481 26.6731C32.1576 26.0636 32.5 25.237 32.5 24.375V9.75C32.5 8.88805 32.1576 8.0614 31.5481 7.4519C30.9386 6.84241 30.112 6.5 29.25 6.5H8.125C7.26305 6.5 6.4364 6.84241 5.8269 7.4519C5.21741 8.0614 4.875 8.88805 4.875 9.75V33.4523ZM4.875 35.75H3.25V9.75C3.25 8.45707 3.76361 7.21709 4.67785 6.30285C5.59209 5.38861 6.83207 4.875 8.125 4.875H29.25C30.5429 4.875 31.7829 5.38861 32.6971 6.30285C33.6114 7.21709 34.125 8.45707 34.125 9.75V24.375C34.125 25.6679 33.6114 26.9079 32.6971 27.8221C31.7829 28.7364 30.5429 29.25 29.25 29.25H11.375L4.875 35.75ZM9.75 11.375H27.625V13H9.75V11.375ZM9.75 16.25H27.625V17.875H9.75V16.25ZM9.75 21.125H22.75V22.75H9.75V21.125Z"
                                        fill="#288ED9"></path>
                                </svg>

                            </div>
                            <div class="title-box">
                                <h3 class="title">
                                    نظرات
                                </h3>
                                <div class="blue-line"></div>
                            </div>
                            @if(!$episode->comments->where('status' , 1)->count())
                                <p class="subtitle">
                                    هنوز نظری برای این دوره ثبت نشده است
                                </p>
                            @endif
                        </div>

                    </div>
                    @include('comment::frontend.show' , [
                  'comments' => $episode->comments->whereNull('parent_id')->where('status' , 1) ,
                  'comment_reply' => false
                  ])
                </div>
            </div>


            <div class="col-md-4 col-lg-3 kw-p-single-sidebar">
                <!--pricing section in sidebar-->
                <div class="kw-wrapper kw-wrapper-br p-3 kw-mt-1rem">
                    @include('course::frontend.partials.pricing-section' , ['course' , $course])
                </div>
                <!--pricing section in sidebar end-->
                <div class="kw-wrapper kw-wrapper-br p-3 kw-mt-1rem mt-3">
                    <div class="section-head">
                        <div class="section-title">
                            <div class="title-icon">
                                <svg width="28" height="18" viewBox="0 0 28 18" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M0 1.625V0H27.625V1.625H0ZM27.625 8.125V9.75H0V8.125H27.625ZM0 16.25H27.625V17.875H0V16.25Z"
                                        fill="#288ED9"></path>
                                </svg>
                            </div>
                            <div class="title-box">
                                <h6 class="title">جزئیات این قسمت</h6>
                                <div class="blue-line"></div>
                            </div>
                        </div>
                    </div>
                    <div class="kw-p-single-details p-3">
                        <ul class="kw-list1">
                            <li>
                                تاریخ آپلود این قسمت:
                                <strong>{{\Hekmatinasser\Verta\Verta::instance($episode->created_at)->format('%d %B، %Y')}}</strong>
                                <hr>
                            </li>
                            <li>
                                مدرس: <strong>{{$course->teacher}} </strong>
                            </li>
                            {{--                                <li>--}}
                            {{--                                    تعداد دانشجویان: <strong>{{$course->users->count()}}</strong>--}}
                            {{--                                </li>--}}
                        </ul>
                    </div>

                </div>
                @auth
                    <form class="p-0" method="post" id="download"
                          action="{{\Illuminate\Support\Facades\URL::temporarySignedRoute('get.episode.download' , now()->addMinutes(30) )}}">
                        @csrf
                        @method('post')
                        <input type="hidden" name="ptg" value="{{encrypt($episode->video)}}">
                    </form>
                    @if(!$episode->is_free)

                        @if($course->users->where('id' , auth()->user()->id)->count())
                            <div>
                                <a href="#" class="kw-btn-orange btn-block"
                                   onclick="event.preventDefault();document.getElementById('download').submit()">
                                    <svg width="16" height="14" viewBox="0 0 16 14" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.5 8.8999C0.632608 8.8999 0.759785 8.95258 0.853553 9.04635C0.947322 9.14012 1 9.26729 1 9.3999V11.8999C1 12.1651 1.10536 12.4195 1.29289 12.607C1.48043 12.7945 1.73478 12.8999 2 12.8999H14C14.2652 12.8999 14.5196 12.7945 14.7071 12.607C14.8946 12.4195 15 12.1651 15 11.8999V9.3999C15 9.26729 15.0527 9.14012 15.1464 9.04635C15.2402 8.95258 15.3674 8.8999 15.5 8.8999C15.6326 8.8999 15.7598 8.95258 15.8536 9.04635C15.9473 9.14012 16 9.26729 16 9.3999V11.8999C16 12.4303 15.7893 12.939 15.4142 13.3141C15.0391 13.6892 14.5304 13.8999 14 13.8999H2C1.46957 13.8999 0.960859 13.6892 0.585786 13.3141C0.210714 12.939 0 12.4303 0 11.8999V9.3999C0 9.26729 0.0526784 9.14012 0.146447 9.04635C0.240215 8.95258 0.367392 8.8999 0.5 8.8999V8.8999Z"
                                            fill="#FF5C00"/>
                                        <path
                                            d="M7.64614 10.854C7.69259 10.9006 7.74776 10.9375 7.80851 10.9627C7.86925 10.9879 7.93438 11.0009 8.00014 11.0009C8.06591 11.0009 8.13103 10.9879 8.19178 10.9627C8.25252 10.9375 8.3077 10.9006 8.35414 10.854L11.3541 7.854C11.448 7.76011 11.5008 7.63278 11.5008 7.5C11.5008 7.36722 11.448 7.23989 11.3541 7.146C11.2603 7.05211 11.1329 6.99937 11.0001 6.99937C10.8674 6.99937 10.74 7.05211 10.6461 7.146L8.50014 9.293V0.5C8.50014 0.367392 8.44747 0.240215 8.3537 0.146447C8.25993 0.0526784 8.13275 0 8.00014 0C7.86754 0 7.74036 0.0526784 7.64659 0.146447C7.55282 0.240215 7.50014 0.367392 7.50014 0.5V9.293L5.35414 7.146C5.26026 7.05211 5.13292 6.99937 5.00014 6.99937C4.86737 6.99937 4.74003 7.05211 4.64614 7.146C4.55226 7.23989 4.49951 7.36722 4.49951 7.5C4.49951 7.63278 4.55226 7.76011 4.64614 7.854L7.64614 10.854V10.854Z"
                                            fill="#FF5C00"/>
                                    </svg>
                                    دانلود این قسمت</a>
                            </div>
                        @endif
                    @else
                        <div>
                            <a href="#" class="kw-btn-orange btn-block"
                               onclick="event.preventDefault();document.getElementById('download').submit()">
                                <svg width="16" height="14" viewBox="0 0 16 14" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M0.5 8.8999C0.632608 8.8999 0.759785 8.95258 0.853553 9.04635C0.947322 9.14012 1 9.26729 1 9.3999V11.8999C1 12.1651 1.10536 12.4195 1.29289 12.607C1.48043 12.7945 1.73478 12.8999 2 12.8999H14C14.2652 12.8999 14.5196 12.7945 14.7071 12.607C14.8946 12.4195 15 12.1651 15 11.8999V9.3999C15 9.26729 15.0527 9.14012 15.1464 9.04635C15.2402 8.95258 15.3674 8.8999 15.5 8.8999C15.6326 8.8999 15.7598 8.95258 15.8536 9.04635C15.9473 9.14012 16 9.26729 16 9.3999V11.8999C16 12.4303 15.7893 12.939 15.4142 13.3141C15.0391 13.6892 14.5304 13.8999 14 13.8999H2C1.46957 13.8999 0.960859 13.6892 0.585786 13.3141C0.210714 12.939 0 12.4303 0 11.8999V9.3999C0 9.26729 0.0526784 9.14012 0.146447 9.04635C0.240215 8.95258 0.367392 8.8999 0.5 8.8999V8.8999Z"
                                        fill="#FF5C00"/>
                                    <path
                                        d="M7.64614 10.854C7.69259 10.9006 7.74776 10.9375 7.80851 10.9627C7.86925 10.9879 7.93438 11.0009 8.00014 11.0009C8.06591 11.0009 8.13103 10.9879 8.19178 10.9627C8.25252 10.9375 8.3077 10.9006 8.35414 10.854L11.3541 7.854C11.448 7.76011 11.5008 7.63278 11.5008 7.5C11.5008 7.36722 11.448 7.23989 11.3541 7.146C11.2603 7.05211 11.1329 6.99937 11.0001 6.99937C10.8674 6.99937 10.74 7.05211 10.6461 7.146L8.50014 9.293V0.5C8.50014 0.367392 8.44747 0.240215 8.3537 0.146447C8.25993 0.0526784 8.13275 0 8.00014 0C7.86754 0 7.74036 0.0526784 7.64659 0.146447C7.55282 0.240215 7.50014 0.367392 7.50014 0.5V9.293L5.35414 7.146C5.26026 7.05211 5.13292 6.99937 5.00014 6.99937C4.86737 6.99937 4.74003 7.05211 4.64614 7.146C4.55226 7.23989 4.49951 7.36722 4.49951 7.5C4.49951 7.63278 4.55226 7.76011 4.64614 7.854L7.64614 10.854V10.854Z"
                                        fill="#FF5C00"/>
                                </svg>
                                دانلود این قسمت</a>
                        </div>
                    @endif
                @endauth
                @guest
                    <div>
                        <a href="{{route('login')}}" class="kw-btn-orange btn-block">
                            <svg width="16" height="14" viewBox="0 0 16 14" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M0.5 8.8999C0.632608 8.8999 0.759785 8.95258 0.853553 9.04635C0.947322 9.14012 1 9.26729 1 9.3999V11.8999C1 12.1651 1.10536 12.4195 1.29289 12.607C1.48043 12.7945 1.73478 12.8999 2 12.8999H14C14.2652 12.8999 14.5196 12.7945 14.7071 12.607C14.8946 12.4195 15 12.1651 15 11.8999V9.3999C15 9.26729 15.0527 9.14012 15.1464 9.04635C15.2402 8.95258 15.3674 8.8999 15.5 8.8999C15.6326 8.8999 15.7598 8.95258 15.8536 9.04635C15.9473 9.14012 16 9.26729 16 9.3999V11.8999C16 12.4303 15.7893 12.939 15.4142 13.3141C15.0391 13.6892 14.5304 13.8999 14 13.8999H2C1.46957 13.8999 0.960859 13.6892 0.585786 13.3141C0.210714 12.939 0 12.4303 0 11.8999V9.3999C0 9.26729 0.0526784 9.14012 0.146447 9.04635C0.240215 8.95258 0.367392 8.8999 0.5 8.8999V8.8999Z"
                                    fill="#FF5C00"/>
                                <path
                                    d="M7.64614 10.854C7.69259 10.9006 7.74776 10.9375 7.80851 10.9627C7.86925 10.9879 7.93438 11.0009 8.00014 11.0009C8.06591 11.0009 8.13103 10.9879 8.19178 10.9627C8.25252 10.9375 8.3077 10.9006 8.35414 10.854L11.3541 7.854C11.448 7.76011 11.5008 7.63278 11.5008 7.5C11.5008 7.36722 11.448 7.23989 11.3541 7.146C11.2603 7.05211 11.1329 6.99937 11.0001 6.99937C10.8674 6.99937 10.74 7.05211 10.6461 7.146L8.50014 9.293V0.5C8.50014 0.367392 8.44747 0.240215 8.3537 0.146447C8.25993 0.0526784 8.13275 0 8.00014 0C7.86754 0 7.74036 0.0526784 7.64659 0.146447C7.55282 0.240215 7.50014 0.367392 7.50014 0.5V9.293L5.35414 7.146C5.26026 7.05211 5.13292 6.99937 5.00014 6.99937C4.86737 6.99937 4.74003 7.05211 4.64614 7.146C4.55226 7.23989 4.49951 7.36722 4.49951 7.5C4.49951 7.63278 4.55226 7.76011 4.64614 7.854L7.64614 10.854V10.854Z"
                                    fill="#FF5C00"/>
                            </svg>
                            برای دانلود وارد وب سایت شوید</a>
                    </div>
                @endguest

                <div class="kw-wrapper kw-wrapper-br bg-red p-3 kw-mt-1rem mt-3">
                    <div class="section-head kw-copyright-section">
                        <div class="section-title">
                            <div class="title-icon">
                                <svg class="kw-copyright-svg" width="31" height="31" viewBox="0 0 31 31" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M15.4375 0C19.5318 0 23.4584 1.62645 26.3535 4.52154C29.2486 7.41663 30.875 11.3432 30.875 15.4375C30.875 19.5318 29.2486 23.4584 26.3535 26.3535C23.4584 29.2486 19.5318 30.875 15.4375 30.875C11.3432 30.875 7.41663 29.2486 4.52154 26.3535C1.62645 23.4584 0 19.5318 0 15.4375C0 11.3432 1.62645 7.41663 4.52154 4.52154C7.41663 1.62645 11.3432 0 15.4375 0ZM15.4375 1.625C11.7742 1.625 8.26093 3.08024 5.67059 5.67059C3.08024 8.26093 1.625 11.7742 1.625 15.4375C1.625 19.1008 3.08024 22.6141 5.67059 25.2044C8.26093 27.7948 11.7742 29.25 15.4375 29.25C19.1008 29.25 22.6141 27.7948 25.2044 25.2044C27.7948 22.6141 29.25 19.1008 29.25 15.4375C29.25 11.7742 27.7948 8.26093 25.2044 5.67059C22.6141 3.08024 19.1008 1.625 15.4375 1.625ZM14.625 22.75V19.5H16.25V22.75H14.625ZM14.625 16.25V8.125H16.25V16.25H14.625Z"
                                        fill="white"></path>
                                </svg>
                            </div>
                            <div class="title-box">
                                <p class="subtitle text-white">هرگونه استفاده غیر قانونی از این دوره پیگرد قانونی
                                    دارد.</p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>

@section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="{{asset('/js/responsive-sidebar.js')}}"></script>
    <script src="{{asset('/assets/js/comments.js')}}"></script>
@stop
@endcomponent
