@component('frontend.layouts.content' , ['title' => $course->title , 'subtitle' => 'لذت یادگیری با کاراوب...'])

    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="{{route('main')}}">خانه</a></li>
        <li class="breadcrumb-item"><a href="{{route('courses.all')}}">آکادمی</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{$course->title}}</li>
    @endslot
    @section('head')
        <script type="application/ld+json">
    [{
        "@context": "https://schema.org/",
        "@type": "Course",
        "name": "{{$course->title}}",
        "aggregateRating": {
        "@type": "AggregateRating",
        "ratingValue": "5",
        "ratingCount": "{{$course->rating_count}}",
        "bestRating": "5",
        "worstRating": "1"
    }}]
</script>
    @stop
    <div class="float-sidebar">
        <a id="details">جزئیات</a>
    </div>
    <section>
        <div class="container">
            <div class="row mt-5">
                <div class="col-md-12 col-lg-9">
                    <!--details-->
                    <div class="kw-wrapper kw-wrapper-br p-4">
                        <div class="section-head">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="50" height="50" viewBox="0 0 50 50" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M35.9375 34.2424L25 40.3948L14.0625 34.2424V27.7422L10.9375 26.0061V36.07L25 43.9801L39.0625 36.07V26.0061L35.9375 27.7422V34.2424V34.2424Z"
                                            fill="#288ED9"></path>
                                        <path
                                            d="M25 4.48987L3.125 15.8324V18.5408L25 30.6933L43.75 20.277V28.9062H46.875V15.8324L25 4.48987ZM40.625 18.4382L37.5 20.1742L25 27.1191L12.5 20.1742L9.375 18.4382L7.20908 17.2349L25 8.00999L42.7909 17.2349L40.625 18.4382Z"
                                            fill="#288ED9"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <h3 class="title">
                                        توضیحات کامل {{$course->title}}
                                    </h3>
                                    <p>توضیحاتی درباره ی این دوره آموزشی...</p>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>
                        <div class="text-container gradient position-relative p-4">
                            {!! $course->body !!}
                            <button class="show-btn kw-btn-blue">ادامه مطلب</button>
                        </div>
                    </div>
                    <!--episodes-->
                    @include('course::frontend.partials.episodes' , ['course' => $course ])
                    <!--episodes end-->
                @auth
                    <!--send comment-->
                        <div class="kw-wrapper kw-wrapper-br mt-3" id="addcomment">
                            <div class="section-head p-3">
                                <div class="section-title">
                                    <div class="title-icon">
                                        <svg width="39" height="39" viewBox="0 0 39 39" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M4.875 33.4523L10.7023 27.625H29.25C30.112 27.625 30.9386 27.2826 31.5481 26.6731C32.1576 26.0636 32.5 25.237 32.5 24.375V9.75C32.5 8.88805 32.1576 8.0614 31.5481 7.4519C30.9386 6.84241 30.112 6.5 29.25 6.5H8.125C7.26305 6.5 6.4364 6.84241 5.8269 7.4519C5.21741 8.0614 4.875 8.88805 4.875 9.75V33.4523ZM4.875 35.75H3.25V9.75C3.25 8.45707 3.76361 7.21709 4.67785 6.30285C5.59209 5.38861 6.83207 4.875 8.125 4.875H29.25C30.5429 4.875 31.7829 5.38861 32.6971 6.30285C33.6114 7.21709 34.125 8.45707 34.125 9.75V24.375C34.125 25.6679 33.6114 26.9079 32.6971 27.8221C31.7829 28.7364 30.5429 29.25 29.25 29.25H11.375L4.875 35.75ZM9.75 11.375H27.625V13H9.75V11.375ZM9.75 16.25H27.625V17.875H9.75V16.25ZM9.75 21.125H22.75V22.75H9.75V21.125Z"
                                                fill="#288ED9"></path>
                                        </svg>
                                    </div>
                                    <div class="title-box">
                                        <h2 class="title">
                                            ثبت نظر برای این دوره
                                        </h2>
                                        <p>ثبت نظر جدید...</p>
                                        <div class="blue-line"></div>
                                    </div>
                                </div>
                            </div>

                            <form action="" class="mt-0" id="comment-store" method="post">
                                @csrf
                                @method('post')
                                <input type="hidden" id="commentable_id" value="{{$course->id}}">
                                <input type="hidden" id="commentable_type" value="{{get_class($course)}}">
                                <label for="body">نظر شما</label>
                                <textarea name="message" id="body" cols="30" rows="10" class="form-control"></textarea>
                                <a class="kw-btn-green" onclick="sendComment()">ارسال نظر</a>
                            </form>
                        </div>
                    @endauth
                    @guest
                        <div class="alert alert-info mt-3 kw-wrapper-br" role="alert">
                            برای ثبت نظر ابتدا باید ثبت نام کنید.
                        </div>
                @endguest
                <!--comments-->
                    <div class="comments mt-3 kw-wrapper kw-wrapper-br p-3">
                        <div class="section-head p-3">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="39" height="39" viewBox="0 0 39 39" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M4.875 33.4523L10.7023 27.625H29.25C30.112 27.625 30.9386 27.2826 31.5481 26.6731C32.1576 26.0636 32.5 25.237 32.5 24.375V9.75C32.5 8.88805 32.1576 8.0614 31.5481 7.4519C30.9386 6.84241 30.112 6.5 29.25 6.5H8.125C7.26305 6.5 6.4364 6.84241 5.8269 7.4519C5.21741 8.0614 4.875 8.88805 4.875 9.75V33.4523ZM4.875 35.75H3.25V9.75C3.25 8.45707 3.76361 7.21709 4.67785 6.30285C5.59209 5.38861 6.83207 4.875 8.125 4.875H29.25C30.5429 4.875 31.7829 5.38861 32.6971 6.30285C33.6114 7.21709 34.125 8.45707 34.125 9.75V24.375C34.125 25.6679 33.6114 26.9079 32.6971 27.8221C31.7829 28.7364 30.5429 29.25 29.25 29.25H11.375L4.875 35.75ZM9.75 11.375H27.625V13H9.75V11.375ZM9.75 16.25H27.625V17.875H9.75V16.25ZM9.75 21.125H22.75V22.75H9.75V21.125Z"
                                            fill="#288ED9"></path>
                                    </svg>

                                </div>
                                <div class="title-box">
                                    <h3 class="title">
                                        نظرات
                                    </h3>
                                    <div class="blue-line"></div>
                                </div>
                                @if(!$course->comments->where('status' , 1)->count())
                                    <p class="subtitle">
                                        هنوز نظری برای این دوره ثبت نشده است
                                    </p>
                                @endif
                            </div>

                        </div>
                        @include('comment::frontend.show' , [
                      'comments' => $course->comments->whereNull('parent_id')->where('status' , 1) ,
                      'comment_reply' => false
                      ])
                    </div>
                </div>


                <div class="col-md-4 col-lg-3 kw-p-single-sidebar">
                    <!--pricing section in sidebar-->
                    <div class="kw-wrapper kw-wrapper-br p-3 kw-mt-1rem">
                        @include('course::frontend.partials.pricing-section' , ['course' , $course])
                    </div>
                    <!--pricing section in sidebar end-->
                    <div class="kw-wrapper kw-wrapper-br p-3 kw-mt-1rem mt-3">
                        <div class="section-head">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="28" height="18" viewBox="0 0 28 18" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0 1.625V0H27.625V1.625H0ZM27.625 8.125V9.75H0V8.125H27.625ZM0 16.25H27.625V17.875H0V16.25Z"
                                            fill="#288ED9"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <h6 class="title">جزئیات دوره</h6>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>
                        <div class="kw-p-single-details p-3">
                            <ul class="kw-list1">
                                <li>
                                    تاریخ شروع دوره:
                                    <strong>{{\Hekmatinasser\Verta\Verta::instance($course->created_at)->format('%d %B، %Y')}}</strong>
                                    <hr>
                                </li>
                                <li>
                                    تعداد قسمت های دوره: <strong>{{$course->episodes->count()}} قسمت </strong>
                                    <hr>
                                </li>
                                <li>
                                    مدت زمان دوره: <strong>{{$course->time}}</strong>

                                </li>
                                {{--                                <li>--}}
                                {{--                                    تعداد دانشجویان: <strong>{{$course->users->count()}}</strong>--}}
                                {{--                                </li>--}}
                            </ul>
                        </div>

                    </div>
                    <div class="kw-wrapper kw-wrapper-br p-3 kw-mt-1rem mt-3">
                        <div class="section-head">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="28" height="31" viewBox="0 0 28 31" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M16.2511 4.875H17.8761V3.25C17.8761 2.81902 17.7049 2.4057 17.4002 2.10095C17.0954 1.79621 16.6821 1.625 16.2511 1.625H11.3761C10.9451 1.625 10.5318 1.79621 10.2271 2.10095C9.92233 2.4057 9.75113 2.81902 9.75113 3.25V4.875H11.3761V8.242L2.08925 24.3262C1.79293 24.8195 1.63286 25.3825 1.62539 25.9578C1.61792 26.5331 1.76333 27.1001 2.04675 27.6009C2.33016 28.1016 2.74143 28.5181 3.23854 28.8079C3.73564 29.0976 4.30075 29.2502 4.87613 29.25H22.7511C23.3265 29.2502 23.8916 29.0976 24.3887 28.8079C24.8858 28.5181 25.2971 28.1016 25.5805 27.6009C25.8639 27.1001 26.0093 26.5331 26.0019 25.9578C25.9944 25.3825 25.8343 24.8195 25.538 24.3262L16.2511 8.242V4.875ZM4.87613 30.875C3.99846 30.8752 3.13702 30.6385 2.38272 30.1898C1.62842 29.7411 1.00924 29.0971 0.590535 28.3257C0.171827 27.5544 -0.0308794 26.6843 0.00381014 25.8073C0.0384997 24.9303 0.309298 24.079 0.787625 23.3431L9.75113 7.81787V6.5C9.32015 6.5 8.90682 6.32879 8.60208 6.02405C8.29733 5.7193 8.12613 5.30598 8.12613 4.875V3.25C8.12613 2.38805 8.46854 1.5614 9.07803 0.951903C9.68752 0.34241 10.5142 0 11.3761 0H16.2511C17.1131 0 17.9397 0.34241 18.5492 0.951903C19.1587 1.5614 19.5011 2.38805 19.5011 3.25V4.875C19.5011 5.30598 19.3299 5.7193 19.0252 6.02405C18.7204 6.32879 18.3071 6.5 17.8761 6.5V7.81787L26.8396 23.3431C27.318 24.079 27.5888 24.9303 27.6234 25.8073C27.6581 26.6843 27.4554 27.5544 27.0367 28.3257C26.618 29.0971 25.9988 29.7411 25.2445 30.1898C24.4902 30.6385 23.6288 30.8752 22.7511 30.875H4.87613ZM15.1039 19.9745L17.7461 17.3323L22.7511 26H4.87613L10.8236 15.6975L15.1039 19.9745ZM15.1039 22.2722L11.173 18.343L7.69062 24.375H19.9366L17.3984 19.9777L15.1039 22.2722ZM14.6261 11.375C15.0571 11.375 15.4704 11.5462 15.7752 11.851C16.0799 12.1557 16.2511 12.569 16.2511 13C16.2511 13.431 16.0799 13.8443 15.7752 14.149C15.4704 14.4538 15.0571 14.625 14.6261 14.625C14.1951 14.625 13.7818 14.4538 13.4771 14.149C13.1723 13.8443 13.0011 13.431 13.0011 13C13.0011 12.569 13.1723 12.1557 13.4771 11.851C13.7818 11.5462 14.1951 11.375 14.6261 11.375Z"
                                            fill="#4B3DA7"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <h6 class="title">درصد پیشرفت دوره</h6>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>
                        <div class="p-3">
                            <div class="progress">
                                <div class="progress-bar progress-bar-striped bg-success" role="progressbar"
                                     style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100">100%
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="kw-wrapper kw-wrapper-br p-3 kw-mt-1rem mt-3">
                        <div class="section-head">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="28" height="28" viewBox="0 0 50 50" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M35.9375 34.2424L25 40.3948L14.0625 34.2424V27.7422L10.9375 26.0061V36.07L25 43.9801L39.0625 36.07V26.0061L35.9375 27.7422V34.2424V34.2424Z"
                                            fill="#288ED9"></path>
                                        <path
                                            d="M25 4.48987L3.125 15.8324V18.5408L25 30.6933L43.75 20.277V28.9062H46.875V15.8324L25 4.48987ZM40.625 18.4382L37.5 20.1742L25 27.1191L12.5 20.1742L9.375 18.4382L7.20908 17.2349L25 8.00999L42.7909 17.2349L40.625 18.4382Z"
                                            fill="#288ED9"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <h6 class="title">دوره های دیگر</h6>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>
                        <div class="categories p-3">
                            <ul class="cards-img-right">
                                @foreach($courses as $other_course)
                                    <li class="card-item mt-0">
                                        <img src="{{asset($other_course->image)}}"
                                             alt="" style="width: 70px">
                                        <div class="d-flex flex-column">
                                            <a href="what-is-web-design" style="text-decoration: none; color: black">
                                                <strong>{{$other_course->title}}</strong>
                                            </a>
                                            <p class="subtitle">
                                                @switch($other_course->price)
                                                    @case(0)
                                                    رایگان
                                                    @break
                                                    @case(!0)
                                                    {{number_format($other_course->price)}} تومان
                                                    @break

                                                @endswitch
                                            </p>
                                        </div>

                                    </li>
                                @endforeach

                            </ul>
                        </div>

                    </div>
                    <div class="kw-wrapper kw-wrapper-br bg-red p-3 kw-mt-1rem mt-3">
                        <div class="section-head kw-copyright-section">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg class="kw-copyright-svg" width="31" height="31" viewBox="0 0 31 31" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M15.4375 0C19.5318 0 23.4584 1.62645 26.3535 4.52154C29.2486 7.41663 30.875 11.3432 30.875 15.4375C30.875 19.5318 29.2486 23.4584 26.3535 26.3535C23.4584 29.2486 19.5318 30.875 15.4375 30.875C11.3432 30.875 7.41663 29.2486 4.52154 26.3535C1.62645 23.4584 0 19.5318 0 15.4375C0 11.3432 1.62645 7.41663 4.52154 4.52154C7.41663 1.62645 11.3432 0 15.4375 0ZM15.4375 1.625C11.7742 1.625 8.26093 3.08024 5.67059 5.67059C3.08024 8.26093 1.625 11.7742 1.625 15.4375C1.625 19.1008 3.08024 22.6141 5.67059 25.2044C8.26093 27.7948 11.7742 29.25 15.4375 29.25C19.1008 29.25 22.6141 27.7948 25.2044 25.2044C27.7948 22.6141 29.25 19.1008 29.25 15.4375C29.25 11.7742 27.7948 8.26093 25.2044 5.67059C22.6141 3.08024 19.1008 1.625 15.4375 1.625ZM14.625 22.75V19.5H16.25V22.75H14.625ZM14.625 16.25V8.125H16.25V16.25H14.625Z"
                                            fill="white"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <p class="subtitle text-white">هرگونه استفاده غیر قانونی از این دوره پیگرد قانونی
                                        دارد.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>

@section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="{{asset('/js/responsive-sidebar.js')}}"></script>
    <script src="{{asset('/assets/js/comments.js')}}"></script>
@stop
@endcomponent
