@component('frontend.layouts.content' , ['title' => 'آکادمی کاراوب' , 'subtitle' => 'لذت یادگیری با آکادمی کاراوب...'])

    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="{{route('main')}}">خانه</a></li>
        <li class="breadcrumb-item active" aria-current="page">آکادمی کاراوب</li>
    @endslot
    <section>
        <div class="container">
            <div class="row mt-5">
                <div class="col-md-12 col-lg-12">
                    <div class="section-head">
                        <div class="section-title">
                            <div class="title-icon">
                                <svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M35.9375 34.2424L25 40.3948L14.0625 34.2424V27.7422L10.9375 26.0061V36.07L25 43.9801L39.0625 36.07V26.0061L35.9375 27.7422V34.2424V34.2424Z" fill="#288ED9"></path>
                                    <path d="M25 4.48987L3.125 15.8324V18.5408L25 30.6933L43.75 20.277V28.9062H46.875V15.8324L25 4.48987ZM40.625 18.4382L37.5 20.1742L25 27.1191L12.5 20.1742L9.375 18.4382L7.20908 17.2349L25 8.00999L42.7909 17.2349L40.625 18.4382Z" fill="#288ED9"></path>
                                </svg>
                            </div>
                            <div class="title-box">
                                <h3 class="title">
                                    آخرین دوره های آموزشی
                                </h3>
                                <p>طراحی حرفه ای سایت از صفر...</p>
                                <div class="blue-line"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row kw-blog">
                        @foreach($courses as $course)
                            <div class="col-md-3">
                                <div class="kw-blog-card kw-wrapper kw-wrapper-br">
                                    <div class="post-cover position-relative">
                                        <a href="{{route('courses.show' , $course)}}">
                                            <img src="{{$course->image}}" alt="">
                                        </a>
                                        @auth
                                            @if($course->users->where('id' , auth()->user()->id)->count())
                                                <span class="mt-3 position-absolute student-badge">شما دانشجوی این دوره هستید</span>
                                            @endif
                                        @endauth

                                    </div>
                                    <div class="post-details">
                                        <a href="{{route('courses.show' , $course)}}">
                                            <h3>{{$course->title}}</h3>
                                        </a>
                                        <p class="subtitle">
                                            {{\Illuminate\Support\Str::limit(strip_tags($course->body),50)}}
                                        </p>

                                    </div>
                                    <hr>
                                    <div class="kw-academy-footer pb-3">
                                        <div class="details">
                                            <p class="subtitle">
                                                <svg width="30" height="30" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M5.75 1.5C7.00978 1.5 8.21796 2.00044 9.10876 2.89124C9.99955 3.78204 10.5 4.99022 10.5 6.25C10.5 7.50978 9.99955 8.71796 9.10876 9.60876C8.21796 10.4996 7.00978 11 5.75 11C4.49022 11 3.28204 10.4996 2.39124 9.60876C1.50044 8.71796 1 7.50978 1 6.25C1 4.99022 1.50044 3.78204 2.39124 2.89124C3.28204 2.00044 4.49022 1.5 5.75 1.5ZM5.75 2C4.62283 2 3.54183 2.44777 2.7448 3.2448C1.94777 4.04183 1.5 5.12283 1.5 6.25C1.5 7.37717 1.94777 8.45817 2.7448 9.2552C3.54183 10.0522 4.62283 10.5 5.75 10.5C6.87717 10.5 7.95817 10.0522 8.7552 9.2552C9.55223 8.45817 10 7.37717 10 6.25C10 5.12283 9.55223 4.04183 8.7552 3.2448C7.95817 2.44777 6.87717 2 5.75 2ZM5.5 3.5H6V6.2115L8.348 7.567L8.098 8L5.5 6.5V3.5Z" fill="#288ED9"></path>
                                                </svg>
                                                {{$course->time}}
                                            </p>
                                        </div>
                                        @if($course->price != 0)
                                            <a href="#" class="kw-btn-blue mt-0">
                                                {{number_format($course->price)}}
                                            </a>
                                        @else
                                            <a href="#" class="kw-btn-green mt-0">
                                                رایگان
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </div>

                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
@endcomponent
