<?php

namespace Modules\Course\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Modules\Course\Notifications\channels\ClientSmsChannel;

class SuccessfulCoursePurchase extends Notification
{
    use Queueable;

   public $phone;
   public $name;
   public $pattern;
    public function __construct($phone , $name , $pattern)
    {
        $this->phone = $phone;
        $this->name = $name;
        $this->pattern = $pattern;
    }

    public function via($notifiable)
    {
        return [ClientSmsChannel::class];
    }

    public function toClientSmsChannel($notifiable)
    {
        return [
            'name' => $this->name,
            'phone' => $this->phone,
            'pattern' => $this->pattern
        ];
    }
}
