<?php

namespace Modules\Course\Http\Controllers\Front;

use Artesaos\SEOTools\Facades\JsonLd;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Storage;
use Iman\Streamer\VideoStreamer;
use Modules\Course\Entities\Course;
use Modules\Course\Entities\Episode;

class EpisodeController extends Controller
{
    use SEOTools;

    public function show(Course $course, Episode $episode)
    {
        $this->seo()
            ->settitle($episode->title)
            ->setDescription($episode->meta_desc)
            ->addImages(asset($course->image));
        $this->seo()->jsonLd()->setType('VideoObject');
        $this->seo()->jsonLd()->setImages(asset($course->image));
        $this->seo()->jsonLd()->setUrl(asset('series/' . $course->slug . '/' . $episode->slug));
        $this->seo()->opengraph()->addProperty('type', 'video.episode');
        $this->seo()->opengraph()->setUrl(asset('series/' . $course->slug . '/' . $episode->slug));
        JsonLd::addValue('uploadDate', $episode->created_at);
        JsonLd::addValue('contentUrl', $episode->video);
        JsonLd::addValue('embedUrl', $episode->video);
        JsonLd::addValue('thumbnailUrl', asset($course->image));
        SEOMeta::addKeyword($episode->meta_keywords);
        SEOMeta::addMeta('video:published_time', $episode->created_at);
        return view('course::frontend.episodes.show', compact(['course', 'episode']));
    }

    public function getUrl(Course $course)
    {
        $path = Storage::disk('local')->path(\request('path'));
        VideoStreamer::streamFile($path);
    }

    public function download(Request $request)
    {
        $path = decrypt($request->input('ptg'));
        return Storage::download($path);
    }
}
