<?php

namespace Modules\Course\Http\Controllers\Front;

use Artesaos\SEOTools\Facades\OpenGraph;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Course\Entities\Course;

class CourseController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()
            ->settitle('آکادمی کاراوب')
            ->setDescription('آموزش طراحی سایت بدون کد نویسی را میتوانید به صورت رایگان از آکادمی کاراوب دنبال کنید');
        $courses = Course::simplePaginate(12);
        return view('course::frontend.courses.all',compact(['courses']));
    }

    public function show(Course $course)
    {
        $this->seo()
            ->settitle($course->title)
            ->setDescription($course->meta_desc)
            ->addImages(asset($course->image));
        $this->seo()->jsonLd()->setType('WebPage');
        $this->seo()->jsonLd()->setImages(asset($course->image));
        $this->seo()->jsonLd()->setUrl(asset('series/' . $course->slug));
        $this->seo()->opengraph()->addProperty('type', 'Article');
        OpenGraph::setTitle($course->title)
            ->setDescription($course->meta_desc)
            ->setUrl(asset('series/' . $course->slug))
            ->addProperty('locale', 'fa_IR')
            ->setSiteName('کاراوب')
            ->setType('Article');
        SEOMeta::addKeyword($course->meta_keywords);
        $courses = Course::latest()->simplePaginate(4);
        return view('course::frontend.courses.show' , compact(['course' , 'courses']));
    }

    public function register(Request $request , Course $course)
    {
        auth()->user()->courses()->attach($course->id);
        alert()->success("" , 'ثبت نام شدید!');
        return back();
    }

    public function profileCourses()
    {
        $this->seo()
            ->settitle('دوره های آموزشی شما');
        return view('user::frontend.courses.all');
    }

}
