<?php

namespace Modules\Course\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Modules\Comment\Entities\Comment;

class Episode extends Model
{
    use HasFactory;
    use Notifiable;

    protected $fillable = [
        'title',
        'body',
        'slug',
        'course_id',
        'video',
        'meta_title',
        'meta_keywords',
        'meta_desc',
        'status',
        'is_free',
        'rating_count'
    ];
    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    public function comments()
    {
        return $this->morphMany(Comment::class,'commentable');
    }
}
