<?php

namespace Modules\Course\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Modules\Category\Entities\Category;
use Modules\Comment\Entities\Comment;
use Modules\Discount\Entities\Discount;
use Modules\Order\Entities\Order;
use Modules\Ticket\Entities\Ticket;
use Modules\User\Entities\User;

class Course extends Model
{
    use HasFactory;
    use Notifiable;
    protected $fillable = [
        'title',
        'body',
        'slug',
        'time',
        'teacher',
        'price',
        'image',
        'meta_title',
        'meta_keywords',
        'meta_desc',
        'status',
        'video_cover',
        'rating_count'
    ];

    public function episodes()
    {
        return $this->hasMany(Episode::class);
    }

    //many to many polymorphic relationship whit categories table

    public function categories()
    {
        return $this->morphToMany(Category::class , 'categorizable');
    }

    //one to many polymorphic relationship whit comments table

    public function comments()
    {
        return $this->morphMany(Comment::class,'commentable');
    }

    public function orders()
    {
        return $this->belongsToMany(Order::class);
    }

    public function users()
    {
        return $this->belongsToMany(User::class);
    }

    public function discounts()
    {
        return $this->hasMany(Discount::class);
    }

    public function tickets()
    {
        return $this->morphMany(Ticket::class , 'ticketable');
    }

}
