<?php

namespace Modules\Category\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Portfolio\Entities\Portfolio;
use Modules\Post\Entities\Post;

class Category extends Model
{
    use HasFactory;

    protected $fillable = ['name' , 'parent_id'];


    //many to many polymorphic relationship with Posts table

    public function posts()
    {
        return $this->morphedByMany(Post::class , 'categorizable');
    }
    //many to many polymorphic relationship with Portfolios table
    public function portfolios()
    {
        return $this->morphedByMany(Portfolio::class , 'categorizable');
    }

    //many to many polymorphic relationship with Files table

    public function files()
    {
        return $this->morphedByMany(Category::class , 'categorizable');
    }

    //many to many polymorphic relationship with Course table

    public function courses()
    {
        return $this->morphedByMany(Category::class , 'categorizable');
    }

    public function children()
    {
        return $this->hasMany(Category::class, 'parent_id' , 'id');
    }

    public function childrenRecursive()
    {
        return $this->children()->with('childrenRecursive');
    }
}
