@component('frontend.layouts.content' , ['title' => 'سبد خرید شما' , 'subtitle' => 'محصولات موجود در سبد خرید'])

    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="{{route('main')}}">خانه</a></li>
        <li class="breadcrumb-item active" aria-current="page">سبد خرید کاراوب</li>
    @endslot
    <section>
        <div class="container">
            <div class="row mt-5">
                <div class="col-md-12 col-lg-9">
                    <!--details-->
                    <div class="kw-wrapper kw-wrapper-br p-4">
                        <div class="section-head">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="50" height="50" viewBox="0 0 39 39" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M26 29.25C26.862 29.25 27.6886 29.5924 28.2981 30.2019C28.9076 30.8114 29.25 31.638 29.25 32.5C29.25 33.362 28.9076 34.1886 28.2981 34.7981C27.6886 35.4076 26.862 35.75 26 35.75C25.138 35.75 24.3114 35.4076 23.7019 34.7981C23.0924 34.1886 22.75 33.362 22.75 32.5C22.75 31.638 23.0924 30.8114 23.7019 30.2019C24.3114 29.5924 25.138 29.25 26 29.25ZM26 30.875C25.569 30.875 25.1557 31.0462 24.851 31.351C24.5462 31.6557 24.375 32.069 24.375 32.5C24.375 32.931 24.5462 33.3443 24.851 33.649C25.1557 33.9538 25.569 34.125 26 34.125C26.431 34.125 26.8443 33.9538 27.149 33.649C27.4538 33.3443 27.625 32.931 27.625 32.5C27.625 32.069 27.4538 31.6557 27.149 31.351C26.8443 31.0462 26.431 30.875 26 30.875ZM11.375 29.25C12.237 29.25 13.0636 29.5924 13.6731 30.2019C14.2826 30.8114 14.625 31.638 14.625 32.5C14.625 33.362 14.2826 34.1886 13.6731 34.7981C13.0636 35.4076 12.237 35.75 11.375 35.75C10.513 35.75 9.6864 35.4076 9.0769 34.7981C8.46741 34.1886 8.125 33.362 8.125 32.5C8.125 31.638 8.46741 30.8114 9.0769 30.2019C9.6864 29.5924 10.513 29.25 11.375 29.25ZM11.375 30.875C10.944 30.875 10.5307 31.0462 10.226 31.351C9.92121 31.6557 9.75 32.069 9.75 32.5C9.75 32.931 9.92121 33.3443 10.226 33.649C10.5307 33.9538 10.944 34.125 11.375 34.125C11.806 34.125 12.2193 33.9538 12.524 33.649C12.8288 33.3443 13 32.931 13 32.5C13 32.069 12.8288 31.6557 12.524 31.351C12.2193 31.0462 11.806 30.875 11.375 30.875ZM29.25 9.75H6.94362L11.0825 19.5H24.375C24.6277 19.5004 24.8769 19.4415 25.1027 19.328C25.3285 19.2146 25.5245 19.0497 25.675 18.8467L30.55 12.3468H30.5516C30.7318 12.1052 30.8413 11.8183 30.8679 11.5181C30.8944 11.2179 30.837 10.9162 30.7019 10.6468C30.5669 10.3774 30.3596 10.1509 30.1032 9.99248C29.8468 9.8341 29.5514 9.75015 29.25 9.75ZM24.375 21.125H11.1573L9.9125 23.66L9.75 24.375C9.75 24.806 9.92121 25.2193 10.226 25.524C10.5307 25.8288 10.944 26 11.375 26H29.25V27.625H11.375C10.8091 27.6253 10.253 27.4778 9.76159 27.1971C9.27021 26.9165 8.86062 26.5124 8.57335 26.0249C8.28608 25.5373 8.13108 24.9832 8.1237 24.4174C8.11631 23.8516 8.2568 23.2936 8.53125 22.7987L9.70125 20.4035L3.79925 6.5H1.625V4.875H4.875L6.25462 8.125H29.25C29.864 8.12506 30.4655 8.29907 30.9847 8.62689C31.504 8.9547 31.9197 9.4229 32.1838 9.97726C32.4479 10.5316 32.5495 11.1494 32.4769 11.7592C32.4043 12.3689 32.1605 12.9456 31.7736 13.4225L27.0384 19.7372C26.739 20.1659 26.3405 20.516 25.8768 20.7576C25.4131 20.9992 24.8979 21.1252 24.375 21.125Z"
                                            fill="#288ED9"></path>
                                    </svg>

                                </div>
                                <div class="title-box">
                                    <h3 class="title">
                                        سبد خرید
                                    </h3>
                                    <p>خرید ایمن، با کاراوب...</p>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>
                        @foreach(\Modules\Cart\Http\Helpers\Cart::instance('cart')->all() as $cart)
                            @if(isset($cart['course']))
                                @php
                                    $product = $cart['course'];
                                @endphp
                                <div class="cart-item p-4">
                                    <div class="cart-right-item">
                                        <div class="cart-item-img">
                                            <img src="{{$product->image}}" alt="">
                                        </div>
                                        <div class="cart-item-details">
                                            <h3>{{$product->title}}</h3>
                                            <p> مدت زمان دوره: {{$product->time}}</p>
                                            <p>مدرس: {{$product->teacher}}</p>
                                        </div>
                                    </div>
                                    <div class="cart-item-btn">
                                        <form action="{{route('cart.destroy',$cart['id'])}}"
                                              id="delete-cart-{{$product->id}}" method="post">
                                            @csrf
                                            @method('delete')
                                        </form>
                                        <a href="#"
                                           onclick="event.preventDefault(); document.getElementById('delete-cart-{{$product->id}}').submit()"
                                           class="kw-btn-orange-sm">حذف</a>
                                        @if(!$cart['discount_percent'])
                                            <a href="#" class="kw-btn-blue-sm"> {{number_format($product->price)}}
                                                تومان </a>
                                        @else
                                            <del class="kw-btn-blue-sm text-danger text-sm">
                                                {{number_format($product->price)}} تومان
                                            </del>
                                            <span class="mt-2"> {{number_format($product->price - ($product->price * $cart['discount_percent']))}} تومان </span>
                                        @endif

                                    </div>
                                </div>
                            @endif
                        @endforeach

                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="kw-wrapper kw-wrapper-br p-3 kw-mt-1rem">
                        <div class="section-head">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="30" height="30" viewBox="0 0 50 50" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M6.25033 39.5833C6.25033 40.6884 6.68931 41.7482 7.47071 42.5296C8.25212 43.311 9.31192 43.75 10.417 43.75H24.5087C23.4818 42.6053 22.9149 41.1211 22.917 39.5833H6.25033ZM29.167 43.75C30.2721 43.75 31.3319 43.311 32.1133 42.5296C32.8947 41.7482 33.3337 40.6884 33.3337 39.5833V12.5C33.3337 10.9 33.9357 9.4375 34.9253 8.33333H16.667C15.5619 8.33333 14.5021 8.77232 13.7207 9.55372C12.9393 10.3351 12.5003 11.3949 12.5003 12.5V37.5H25.0003V39.5833C25.0003 40.6884 25.4393 41.7482 26.2207 42.5296C27.0021 43.311 28.0619 43.75 29.167 43.75ZM10.417 12.5C10.417 10.8424 11.0755 9.25269 12.2476 8.08058C13.4197 6.90848 15.0094 6.25 16.667 6.25H39.5837C41.2413 6.25 42.831 6.90848 44.0031 8.08058C45.1752 9.25269 45.8337 10.8424 45.8337 12.5V16.6667H35.417V39.5833C35.417 41.2409 34.7585 42.8307 33.5864 44.0028C32.4143 45.1749 30.8246 45.8333 29.167 45.8333H10.417C8.75939 45.8333 7.16968 45.1749 5.99758 44.0028C4.82547 42.8307 4.16699 41.2409 4.16699 39.5833V37.5H10.417V12.5ZM43.7503 14.5833V12.5C43.7503 11.3949 43.3113 10.3351 42.5299 9.55372C41.7485 8.77232 40.6887 8.33333 39.5837 8.33333C38.4786 8.33333 37.4188 8.77232 36.6374 9.55372C35.856 10.3351 35.417 11.3949 35.417 12.5V14.5833H43.7503Z"
                                            fill="#288ED9"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <h3 class="title">
                                        جزئیات خرید
                                    </h3>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>
                        <div class="cart-details">
                            @php
                                $totalPrice = \Modules\Cart\Http\Helpers\Cart::all()->sum(function($cart) {
                                    return $cart['discount_percent'] == 0 ?  $cart['price']
                                        : $cart['price'] - ($cart['price'] * $cart['discount_percent']);
                                });
                            @endphp
                            <strong>مجموع: {{number_format($totalPrice)}} تومان</strong>
                            @if(\Nwidart\Modules\Module::isEnable('Discount'))
                                <hr>
                                @if($discount = \Modules\Cart\Http\Helpers\Cart::getDiscount())
                                    <div class="mt-3">
                                        <form action="{{route('discount.destroy')}}" method="post" id="discount-destroy" class="p-0">
                                            @method('delete')
                                            @csrf
                                        </form>
                                        <span>کد تخفیف فعال: <span class="text-success">{{$discount->code}}</span> <a
                                                onclick="event.preventDefault(); document.getElementById('discount-destroy').submit()"
                                                href="#" class="kw-btn-orange-sm">حذف</a></span>
                                        <div class="mt-1">
                                            درصد تخفیف:
                                             <span class="kw-btn-green">{{$discount->percent}} درصد </span>
                                        </div>
                                    </div>
                                @else
                                    <form action="{{route('discount.check')}}" class="p-0" method="post">
                                        @csrf
                                        @method('post')
                                        <p>آیا کد تخفیف دارید؟</p>
                                        <input type="text" class="form-control @error('discount') is-invalid @enderror"
                                               name="discount" placeholder="کد تخفیف شما">
                                        @error('discount')
                                        <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                        @enderror
                                        <button class="kw-btn-blue btn-block">اعمال کد</button>
                                    </form>
                                @endif

                            @endif
                            <hr>
                            <strong>مبلغ نهایی: {{number_format($totalPrice)}} تومان</strong>
                        </div>
                        <form action="{{route('cart.payment')}}" method="post" class="p-0" id="cart-payment">
                            @csrf
                            @method('post')
                        </form>
                        <a onclick="event.preventDefault(); document.getElementById('cart-payment').submit()"
                           class="kw-btn-green btn-block">تکمیل خرید و پرداخت</a>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endcomponent
