<?php

namespace Modules\Cart\Http\Controllers;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Cart\Http\Helpers\Cart;


class CartController extends Controller
{
    use SEOTools;
    public function cart()
    {
        $this->seo()
            ->settitle('سبد خرید شما');
        return view('cart::cart');
    }

    public function addToCart(Request $request)
    {
        $cart = Cart::instance('cart');
        $model = decrypt($request->input('model'));
        $product = $model::findOrFail($request->input('id'));
        if (!$cart->has($product)) {
            $cart->put([
                'quantity' => 1,
                'price' => $product->price
            ], $product);
        }
        alert()->success('محصول مورد نظر به سبد خرید اضافه شد', 'محصول اضافه شد');

        return redirect(route('cart.show'));
    }

    public function deleteFromCart($id)
    {
        $cart = Cart::instance('cart');
        $cart->delete($id);
        alert()->success('محصول مورد نظر از سبد خرید حذف شد', 'محصول حذف شد');
        return back();
    }

}
