@component('backend.layouts.components.main',['title' => 'مدیریت نقش ها', 'titleBar'=>true , 'button' => 'افزودن نقش' , 'route' => 'admin.roles.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">نقش ها</li>


    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست نقش ها</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>نام</th>
                            <th>توضیحات</th>
                            <th>عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($roles as $role)
                            <tr>
                                <td>
                                    {{$role->name}}
                                </td>
                                <td>
                                    {{$role->label}}
                                </td>
                                <td>
                                    <form action="{{route('admin.roles.destroy', $role->id)}}" method="post"
                                          id="delete-{{$role->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    <a href="{{route('admin.roles.edit', $role->id)}}" role="button"
                                       class="btn btn-success light sharp" title="ویرایش">
                                        <i class="fa fa-pencil"
                                           onclick="document.getElementById('edit-{{$role->id}}').submit()"></i>
                                    </a>
                                    <button onclick="document.getElementById('delete-{{$role->id}}').submit()"
                                            role="button" class="btn btn-danger light sharp" title="حذف">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>

                </div>
                {{$roles->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
