<?php

namespace Modules\ACL\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\ACL\Entities\Permission;

class PermissionController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()->setTitle('همه ی دسترسی ها');
        $permissions = Permission::query();
        if ($key = \request('search')) {
            $permissions = $permissions->where('name' , 'like' , "%$key%");
        }
        $permissions = $permissions->latest()->simplePaginate(15);
        return view('acl::backend.permissions.all' , compact('permissions'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $this->seo()->setTitle('ایجاد دسترسی جدید');
        return view('acl::backend.permissions.create');
    }


    public function store(Request $request)
    {
        $validData = $request->validate([
           'name' => 'required|string|unique:permissions',
           'label' => 'required'
        ]);
        $permission = Permission::create($validData);
        alert()->success('دسترسی با موفقیت ساخته شد.');
        return back();
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('acl::show');
    }


    public function edit(Permission $permission)
    {
        $this->seo()->setTitle("ویرایش دسترسی $permission->name");
        return view('acl::backend.permissions.edit' , compact('permission'));
    }


    public function update(Request $request, Permission $permission)
    {
        $validData = $request->validate([
            'name' => 'required|string|unique:permissions',
            'label' => 'required'
        ]);

        $permission->update($validData);
        alert()->success('دسترسی با موفقیت ویرایش شد.');
        return back();
    }


    public function destroy(Permission $permission)
    {
        $permission->delete();
        alert()->success('دسترسی با موفقیت حذف شد.');
        return back();
    }
}
