<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Front;
use App\Http\Controllers\Admin;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('install/pre-installation', 'InstallController@preInstallation')->name('install.pre_installation');
Route::get('install/configuration', 'InstallController@getConfiguration')->name('install.configuration.show');
Route::post('install/configuration', 'InstallController@postConfiguration')->name('install.configuration.post');
Route::get('install/complete', 'InstallController@complete')->name('install.complete');

Route::get('license', 'LicenseController@create')->name('license.create');
Route::post('license', 'LicenseController@store')->name('license.store');


Route::middleware('checkInstall')->group(function () {
    Route::namespace('Admin')->group(function () {
// route to show the login form
        Route::get('login', 'AuthController@showLogin')->name('login');
// route to process the form
        Route::post('login', 'AuthController@doLogin')->name('doLogin');
        Route::get('/logout', function () {
            \Illuminate\Support\Facades\Auth::logout();
        return \Illuminate\Support\Facades\Redirect::route('Front.index');
        })->name('logoute');
    });

    Route::middleware('auth')->namespace('Admin')->prefix('Admins')->group(function () {

        Route::get('/', 'IndexController@index')->name('Admin.index');
        Route::post('/uploadfile', 'FileController@saveImages');

        Route::prefix('settings')->group(function () {
            Route::get('/', 'SettingsController@index')->name('Admin.settings.index');
            Route::get('/create', 'SettingsController@create')->name('Admin.settings.create');
            Route::get('/show', 'SettingsController@show')->name('Admin.settings.show');
            Route::post('/store', 'SettingsController@store')->name('Admin.settings.store');
            Route::get('/edit', 'SettingsController@edit')->name('Admin.settings.edit');
            Route::post('/update', 'SettingsController@update')->name('Admin.settings.update');
        });

        Route::prefix('services')->group(function () {
            Route::get('/', 'ServiceController@index')->name('Admin.services.index');
            Route::get('/create', 'ServiceController@create')->name('Admin.services.create');
            Route::get('/show', 'ServiceController@show')->name('Admin.services.show');
            Route::post('/store', 'ServiceController@store')->name('Admin.services.store');
            Route::get('/edit/{id}', 'ServiceController@edit')->name('Admin.services.edit');
            Route::post('/update/{id}', 'ServiceController@update')->name('Admin.services.update');
            Route::get('/delete/{id}', 'ServiceController@destroy')->name('Admin.services.delete');
        });


        Route::prefix('skills')->group(function () {
            Route::get('/', 'SkillsController@index')->name('Admin.skills.index');
            Route::get('/create', 'SkillsController@create')->name('Admin.skills.create');
            Route::get('/show', 'SkillsController@show')->name('Admin.skills.show');
            Route::post('/store', 'SkillsController@store')->name('Admin.skills.store');
            Route::get('/edit/{id}', 'SkillsController@edit')->name('Admin.skills.edit');
            Route::post('/update/{id}', 'SkillsController@update')->name('Admin.skills.update');
            Route::get('/delete/{id}', 'SkillsController@destroy')->name('Admin.skills.delete');
        });


        Route::prefix('comments')->group(function () {
            Route::get('/', 'CommentsController@index')->name('Admin.comments.index');
            Route::get('/create', 'CommentsController@create')->name('Admin.comments.create');
            Route::post('/store', 'CommentsController@store')->name('Admin.comments.store');
            Route::get('/edit/{id}', 'CommentsController@edit')->name('Admin.comments.edit');
            Route::post('/update/{id}', 'CommentsController@update')->name('Admin.comments.update');
            Route::get('/confirmation/{id}', 'CommentsController@confirmation')->name('Admin.comments.confirmation');
            Route::get('/delete/{id}', 'CommentsController@destroy')->name('Admin.comments.destroy');
            Route::get('/show/{id}', 'CommentsController@show')->name('Admin.comments.show');
        });

        Route::prefix('blogs')->group(function () {
            Route::get('/', 'BlogsController@index')->name('Admin.blogs.index');
            Route::get('/create', 'BlogsController@create')->name('Admin.blogs.create');
            Route::post('/store', 'BlogsController@store')->name('Admin.blogs.store');
            Route::get('/edit/{id}', 'BlogsController@edit')->name('Admin.blogs.edit');
            Route::post('/update/{id}', 'BlogsController@update')->name('Admin.blogs.update');
            Route::get('/destroy/{id}', 'BlogsController@BlogDelete')->name('Admin.blogs.destroy');
        });

        Route::prefix('sliders')->group(function () {
            Route::get('/', 'SlidersController@index')->name('Admin.sliders.index');
            Route::get('/create', 'SlidersController@create')->name('Admin.sliders.create');
            Route::post('/store', 'SlidersController@store')->name('Admin.sliders.store');
            Route::get('/edit/{id}', 'SlidersController@edit')->name('Admin.sliders.edit');
            Route::post('/update/{id}', 'SlidersController@update')->name('Admin.sliders.update');
            Route::get('/destroy/{id}', 'SlidersController@SliderDelete')->name('Admin.sliders.destroy');
        });

        Route::prefix('counters')->group(function () {
            Route::get('/', 'CountersController@index')->name('Admin.counters.index');
            Route::get('/create', 'CountersController@create')->name('Admin.counters.create');
            Route::post('/store', 'CountersController@store')->name('Admin.counters.store');
            Route::get('/edit/{id}', 'CountersController@edit')->name('Admin.counters.edit');
            Route::post('/update/{id}', 'CountersController@update')->name('Admin.counters.update');
            Route::get('/destroy/{id}', 'CountersController@CounterDelete')->name('Admin.counters.destroy');
        });


        Route::prefix('categorys')->group(function () {
            Route::get('/', 'CategorysController@index')->name('Admin.categorys.index');
            Route::get('/create', 'CategorysController@create')->name('Admin.categorys.create');
            Route::post('/store', 'CategorysController@store')->name('Admin.categorys.store');
            Route::get('/edit/{id}', 'CategorysController@edit')->name('Admin.categorys.edit');
            Route::post('/update/{id}', 'CategorysController@update')->name('Admin.categorys.update');
            Route::get('/destroy/{id}', 'CategorysController@CategoryDelete')->name('Admin.categorys.destroy');
        });

        Route::prefix('portfolios')->group(function () {
            Route::get('/', 'PortfoliosController@index')->name('Admin.portfolios.index');
            Route::get('/create', 'PortfoliosController@create')->name('Admin.portfolios.create');
            Route::post('/store', 'PortfoliosController@store')->name('Admin.portfolios.store');
            Route::get('/edit/{id}', 'PortfoliosController@edit')->name('Admin.portfolios.edit');
            Route::post('/update/{id}', 'PortfoliosController@update')->name('Admin.portfolios.update');
            Route::get('/destroy/{id}', 'PortfoliosController@PortfolioDelete')->name('Admin.portfolios.destroy');
        });


        Route::prefix('resumes')->group(function () {
            Route::get('/', 'ResumesController@index')->name('Admin.resumes.index');
            Route::get('/create', 'ResumesController@create')->name('Admin.resumes.create');
            Route::post('/store', 'ResumesController@store')->name('Admin.resumes.store');
            Route::get('/edit/{id}', 'ResumesController@edit')->name('Admin.resumes.edit');
            Route::post('/update/{id}', 'ResumesController@update')->name('Admin.resumes.update');
            Route::get('/destroy/{id}', 'ResumesController@ResumeDelete')->name('Admin.resumes.destroy');
        });

        Route::prefix('contacts')->group(function () {
            Route::get('/', 'ContactsController@index')->name('Admin.contacts.index');
            Route::get('/show/{id}', 'ContactsController@show')->name('Admin.contacts.show');
            Route::get('/destroy/{id}', 'ContactsController@ContactDelete')->name('Admin.contacts.destroy');
        });


        Route::prefix('users')->group(function () {
            Route::prefix('profile')->group(function () {
                Route::get('/edit', 'UsersController@profileEdit')->name('Admin.users.profile.edit');
                Route::post('/update', 'UsersController@profileUpdate')->name('Admin.users.profile.update');
                Route::post('/updateSocial', 'UsersController@updateSocial')->name('Admin.users.profile.Social.update');
            });
        });


    });

    Route::namespace('Front')->group(function () {
        Route::get('/', 'IndexController@index')->name('Front.index');
        Route::post('contactStore', 'IndexController@contactStore')->name('contacts.store');
        Route::get('/portfolioText/{id}', 'IndexController@portfolioText')->name('portfolios.portfolioText');
        Route::get('/blogsText/{id}', 'IndexController@blogText')->name('blogs.blogText');
        Route::post('commentsStore/{id}', 'IndexController@commentsStore')->name('comments.store');
    });

});
