@extends('Layouts.adminLayout')
@section('title')
    |{{trans('langPanel.commentList')}}
@endsection
@section('css')
    <link rel="stylesheet" type="text/css"
          href="{{ asset('Admin/app-assets/vendors/css/extensions/sweetalert2.min.css') }}">
@endsection
@section('content')



    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
            </div>
            <div class="content-body">
                <!-- Dashboard Analytics Start -->
                <section id="dashboard-analytics">

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                @include('Layouts.msg')

                                <div class="card-header">
                                    <h4 class="mb-0">{{trans('langPanel.commentList')}}</h4>
                                </div>
                                <div class="card-content">
                                    <div class="table-responsive mt-1">
                                        <table class="table table-hover-animation mb-0  data-list-view">
                                            <thead>
                                            <tr>
                                                <th>{{trans('langPanel.index')}}</th>
                                                <th>{{trans('langPanel.sender')}}</th>
                                                <th>{{trans('langPanel.image')}}</th>
                                                <th>{{trans('langPanel.email')}}</th>
                                                <th>{{trans('langPanel.blog')}}</th>
                                                <th>{{trans('langPanel.Possibilities')}}</th>

                                            </tr>
                                            </thead>
                                            <tbody>
                                            @php $i=1; @endphp
                                            @foreach($data['Comments'] as $value)
                                                <tr>
                                                    <td>{{$i++}}</td>
                                                    <td>{{$value->fullname}}</td>
                                                    <td>
                                                        <ul class="list-unstyled users-list m-0  d-flex align-items-center">
                                                            <li data-toggle="tooltip" data-popup="tooltip-custom"
                                                                data-placement="bottom"
                                                                data-original-title="{{$value->title}}"
                                                                class="avatar pull-up">
                                                                <img class="media-object rounded-circle"
                                                                     src="/{{$value->image}}" alt="{{$value->fullname}}"
                                                                     height="30" width="30">
                                                            </li>

                                                        </ul>
                                                    </td>
                                                    <td>{{$value->email}}</td>
                                                    <td>@if(isset($value->blog->title))
                                                            {{$value->blog->title}}
                                                        @else
                                                            {{'نظرات'}}
                                                        @endif</td>
                                                    <td>
                                                        <a href="{{route('Admin.comments.show',$value->id)}}"
                                                           type="button"
                                                           class="btn btn-icon rounded-circle btn-info mr-1 mb-1 waves-effect waves-light"><i
                                                                class="feather icon-eye"></i></a>

                                                        <a href="{{route('Admin.comments.edit',$value->id)}}"
                                                           type="button"
                                                           class="btn btn-icon  rounded-circle btn-warning mr-1 mb-1 waves-effect waves-light"><i
                                                                class="feather icon-edit"></i></a>

                                                        <a onclick="deleteRecord('{{route('Admin.comments.destroy',$value->id)}}')"
                                                           type="button"
                                                           class="btn btn-icon rounded-circle btn-danger mr-1 mb-1 waves-effect waves-light"><i
                                                                class="feather icon-delete"></i></a>

                                                 <a onclick="confirmation('{{route('Admin.comments.confirmation',$value->id)}}')"
                                                           type="button"
                                                           class="btn btn-icon rounded-circle btn-success mr-1 mb-1 waves-effect waves-light"><i
                                                               class="feather icon-check-circle"></i></a>
																
                                                    </td>
                                                </tr>

                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- Dashboard Analytics end -->

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="{{ asset('Admin/app-assets/vendors/js/extensions/sweetalert2.all.min.js')}}"></script>
    <script src="{{ asset('Admin/app-assets/js/scripts/extensions/sweet-alerts.js')}}"></script>

@endsection
