<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\File;

class Settings extends Model
{
    protected $table = 'settings';
    protected $guarded = ['id'];

    public static function getSettingName($nameSettings)
    {
        $setting=Settings::where('name',$nameSettings)->first();
        if($setting!=null)
            return $setting->value;
        else
            return '';
    }
    public static function getSetting($idSettings)
    {
        return Settings::find($idSettings);
    }

    public static function allSettings($paginate = false)
    {
        if ($paginate)
            $settings = Settings::paginate(9);
        else
            $settings = Settings::all();
        return $settings;
    }

    public static function updateSetting(array $data)
    {
        try {
            
            if (!isset($data['service'])) {
                $data['service'] = 0;
            }
            if (!isset($data['resume'])) {
                $data['resume'] = 0;
            }
            if (!isset($data['about'])) {
                $data['about'] = 0;
            }

            if (!isset($data['portfolio'])) {
                $data['portfolio'] = 0;
            }
               if (!isset($data['blog'])) {
                $data['blog'] = 0;
            }
            
                     if (!isset($data['why-me'])) {
                $data['why-me'] = 0;
            }
            
                     if (!isset($data['contact'])) {
                $data['contact'] = 0;
            }
            
                foreach ($data as $key => $item) {
                $setting = Settings::where('name', $key)->first();
                if ($setting != null) {
                    if ($data[$key] instanceof UploadedFile) {
                        $setting->value = storeFile($item, 'file/setting/');
                    } else {
                        $setting->value = $item;
                    }
                    $setting->update();
                } else {
                    $setting = new Settings();
                    $setting->name = $key;
                    if ($data[$key] instanceof UploadedFile) {
                        $setting->value = storeFile($item, 'file/setting/');
                    } else {
                        $setting->value = $item;
                    }
                    $setting->save();
                }
            }
            return true;
        } catch (\Exception $e) {
            dd($e);
            return $e->getMessage();
        }

    }

    public static function storeSetting($id, $data)
    {
        try {
            foreach ($data as $item) {
                $setting = new Settings();
                $setting->name = $item['name'];
                $setting->value = $item['value'];
                $setting->store();
            }
            return true;
        } catch (\Exception $e) {
            return $e->getMessage();
        }

    }

    public static function getSocial()
    {
        $arrayuSocial = ['twitter', 'facebook', 'instagram', 'github', 'codepen', 'telegram'];
        $social = Settings::whereIn('name', $arrayuSocial)->get()->pluck('value', 'name');
        return $social;
    }
}
