<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Blogs;
use App\Model\Blog;
use File;
class BlogsController extends Controller
{

    public function index()
    {

		$Blogs = Blog::getBlogs();
        $all_data = ['Blogs' => $Blogs];
         return view('Admin.Blog.blogList')->with('data', $all_data);
    }


    public function create()
    {
        return view('Admin.Blog.blogInsert');
    }

     public function store(Blogs $request)
    {

        $data['title']=$request->title;
        $data['text']=$request->text;
        $data['author_name']=$request->author_name;
		$hasFile = $request->hasFile('file');
        $file = $request->file('file');
        $allowedfileExtension = ['jpeg', 'jpg', 'png'];
        $filePath = 'File/blog/';
        $image = '';
		  if ($hasFile) {

                $image = storeFile($file, $filePath);
            }
		$data['image']=$image;
        $check=Blog::store($data);
		if ($check === true)
            return redirect()->route('Admin.blogs.create')->with('msgSuccess', trans('langPanel.mission_accomplished'));
        else
            return redirect()->route('Admin.blogs.create')->with('msgError', trans('langPanel.the_operation_failed'));
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
          $Blog=Blog::getBlog($id);
		  $all_data = ['Blog' => $Blog];
         return view('Admin.Blog.blogEdit')->with('data', $all_data);
    }

    public function update(Blogs $request, $id)
    {

        $Blog = Blog::getBlog($id);
        $data['title']=$request->title;
        $data['text']=$request->text;
        $data['author_name']=$request->author_name;
		if($request->file('file'))
		{

		$hasFile = $request->hasFile('file');
        $file = $request->file('file');
        $allowedfileExtension = ['jpeg', 'jpg', 'png'];
        $filePath = 'File/blog/';
		  if ($hasFile)
               $data['image']= storeFile($file, $filePath);
		    if (\Illuminate\Support\Facades\File::exists($Blog->image)) {
                \Illuminate\Support\Facades\File::delete($Blog->image);
                }
		}
		else
		$data['image']=$Blog->image ;

        $check=Blog::updateBlog($data,$id);
		 if ($check === true)
            return redirect()->route('Admin.blogs.index', $id)->with('msgSuccess', trans('langPanel.mission_accomplished'));
        else
            return redirect()->route('Admin.blogs.index', $id)->with('msgError', trans('langPanel.the_operation_failed'));
    }

    public function BlogDelete($id)
    {
         $check=Blog::BlogDelete($id);
		 	 if ($check === true)
            return redirect()->route('Admin.blogs.index', $id)->with('msgSuccess', trans('langPanel.mission_accomplished'));
        else
            return redirect()->route('Admin.blogs.index', $id)->with('msgError', trans('langPanel.the_operation_failed'));
    }

}
