<?php
get_header();
?>
<div class="single-page">
    <div class="container-lg">
        <div class="row">
            <div class="col-12">
                <div class="page-header text-center">
                    <h1 class="page-title  wow fadeInUp" data-wow-delay="0.25s">
                        <?php echo get_the_title(); ?>
                    </h1>
                    <?php get_template_part('templates/content/breadcrumb'); ?>
                </div>
            </div>
        </div>
    </div>
    
    <section class="single-page_inner">
        <?php
        if (have_posts()) :
            while (have_posts()) : the_post();
                ?>
                <div class="container-lg">
                    <div class="col-12 col-md-10 mx-auto">
                        <?php if (has_post_thumbnail()) { ?>
                            <figure class="single-entry_media">
                                <?php the_post_thumbnail('large'); ?>
                            </figure>
                        <?php } ?>
                        <article class="post-single" itemscope="itemscope"
                                 itemtype="http://schema.org/Article">
                            <div class="entry-meta top">
                                <div class="category">
                                    <?php the_category('', ' '); ?>
                                </div>
                                
                                <div class="entry-meta_left d-flex align-items-center">
                                    <span class="entry-published" itemprop="datePublished">
                                        <i class="icon-edit"></i>
                                        <?php echo get_the_date('j . m . Y'); ?>
                                    </span>
   
                                    <span class="meta-col">
                                        <span class="post-label">
                                            <i class="icon-study"></i>
                                            زمان مطالعه :</span>
                                        <span class="meta-item">
                                            
                                            <?php echo get_field('study_time'); ?>
                                        </span>
                                    </span>
                                </div>
                            </div>
                            <div class="default-editor">
                                <?php the_content(); ?>
                            </div>
                        </article>
    
                        <div class="entry-footer">
                            <?php if (has_tag()) { ?>
                                <div class="tags">
                                    <?php the_tags('برچسب ها: ', '', '  '); ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php
            endwhile;
        endif; ?>
    </section>

    <?php

    $id = get_field('similar_blog');
    if ($id) {
        $related_posts = new WP_Query(array(
            'post_type' => 'post',
            'post__in' => $id,
            'posts_per_page' => '4',
        ));

        if ($related_posts->have_posts()) { ?>
            <section class="related-blog">
                <div class="container-lg">
                    <div class="row">
                        <div class="col-12 text-center section-head">
                            <h2 class="section-title">مقالات مشابه</h2>
                        </div>

                        <?php
                        $i = 0.25;
                        while ($related_posts->have_posts()) :
                            $related_posts->the_post();
                            ?>
                            <div class="col-12 col-sm-6 col-md-4 col-lg-3 wow fadeInUp mb-4"
                                 data-wow-delay="<?php echo $i; ?>s">
                                <?php get_template_part('templates/card/blog', 'card'); ?>
                            </div>
                            <?php
                            $i += 0.25; endwhile;
                        ?>
                    </div>
                </div>
            </section>
        <?php }
        wp_reset_query();
    }
    ?>
    
</div>
<?php get_footer('inner'); ?>
