<?php
/**
Include ACF Plugin
**/
add_filter('acf/settings/path', 'my_acf_settings_path');
function my_acf_settings_path( $path ) {
    $path = get_stylesheet_directory() . '/includes/acf/';
    return $path;
}
add_filter('acf/settings/dir', 'my_acf_settings_dir');
function my_acf_settings_dir( $dir ) {
    $dir = get_stylesheet_directory_uri() . '/includes/acf/';
    return $dir;
}
include_once( get_stylesheet_directory() . '/includes/acf/acf.php' );

/**
General Settings
**/
add_action('after_setup_theme', 'unixa_theme_setup');
function unixa_theme_setup(){
    load_theme_textdomain('unixa', get_template_directory() . '/languages');

	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	//Remove Default Wordpress Gallery Styles
	add_filter( 'use_default_gallery_style', '__return_false' );
}
/**
  Proper way to enqueue scripts and styles
**/
function unixa_scripts() {
	$theme_dir = get_template_directory_uri();
	$theme_dir_uri = get_stylesheet_directory_uri() . '/react-app/build';
    $manifest_path = get_stylesheet_directory() . '/react-app/build/asset-manifest.json';

    if (file_exists($manifest_path)) {
        $manifest = json_decode(file_get_contents($manifest_path), true);

        if (isset($manifest['files']['main.css'])) {
            wp_enqueue_style(
                'react-app',
                $theme_dir_uri . $manifest['files']['main.css'],
                array(),
                null
            );
        }

        if (isset($manifest['files']['main.js'])) {
            wp_enqueue_script(
                'react-main',
                $theme_dir_uri . $manifest['files']['main.js'],
                array(),
                null,
                true
            );

        }
    }
	//Styles
	wp_enqueue_style( 'bootstrap',  $theme_dir .'/assets/vendors/bootstrap/bootstrap.rtl.min.css' );
	wp_enqueue_style( 'swiper-css',  $theme_dir .'/assets/vendors/swiper/swiper-bundle.min.css' );
	wp_enqueue_style( 'animate',  $theme_dir .'/assets/vendors/animate.css' );
	wp_enqueue_style( 'style',  $theme_dir .'/style.css' );
	//Scripts
    wp_enqueue_script( 'bootstrap-js',  $theme_dir . '/assets/vendors/bootstrap/bootstrap.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'swiper-js',  $theme_dir . '/assets/vendors/swiper/swiper-bundle.min.js', array(), '1.0', true );
	
	
	//Styles and scripts for Comment Reply
	if ( is_singular() ) {
		wp_enqueue_script( 'comment-reply' );
		wp_enqueue_script( 'validate',  $theme_dir . '/assets/js/jquery.validate.min.js', array(), '1.0', true );
		wp_enqueue_script( 'gsap-js',  $theme_dir . '/assets/vendors/gsap.min.js', array(), '1.0', true );
	}
	wp_enqueue_script( 'wow.min', $theme_dir . '/assets/vendors/wow.min.js', array('jquery'), '1.0', true );

	wp_enqueue_script( 'isotope-js',  $theme_dir . '/assets/vendors/isotope.pkgd.min.js', array(), '1.0', true );
	
	wp_enqueue_script( 'custom.js',  $theme_dir . '/assets/js/custom.js', array('jquery'), '1.0', true );

}
add_action( 'wp_enqueue_scripts', 'unixa_scripts' );
/**
 Starndard Image Sizes
**/
add_action('after_setup_theme', 'unixa_image_sizes');
function unixa_image_sizes(){
	add_image_size( 'small-thumb', 165, 125, true ); // (cropped)
	add_image_size( 'big-thumb', 590, 440, true ); // (cropped)
}

/**
 Register Menu Locations
**/
add_action('after_setup_theme', 'unixa_menus');
function unixa_menus(){
    register_nav_menus( array(
		'main'  => __( 'Main Menu', 'unixa' ),
		'mobile'  => __( 'Mobile Menu', 'unixa' ),
		'footer1'  => __( 'Footer Menu1', 'unixa' ),
		'footer2'  => __( 'Footer Menu2', 'unixa' ),
	) );
}
/**
 Register Sidebar
**/
add_action('after_setup_theme', 'unixa_sidebars');
function unixa_sidebars(){
	register_sidebar(array(
		'name'          => __('sidebar','unixa'),
		'id'            => 'sidebar-blog',
		'description'   => '',
		'class'         => '',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>'
	));
}

/****remove site adminbar *******/
add_filter('show_admin_bar', '__return_false');


if( function_exists('acf_add_options_page') ) {

	acf_add_options_page(array(
		'page_title'    => 'تنظیمات سایت',
		'menu_title'    => 'تنظیمات سایت',
		'menu_slug'     => 'theme-general-settings',
		'capability'    => 'edit_posts',
		'redirect'      => false
	));

	acf_add_options_sub_page(array(
		'page_title'    => 'Theme Home Settings',
		'menu_title'    => 'Home',
		'parent_slug'   => 'theme-general-settings',
	));

}


function create_portfolio_cpt() {
    $labels = array(
        'name' => _x('نمونه کار', 'Post Type General Name', 'unixa'),
        'singular_name' => _x('نمونه کارها', 'Post Type Singular Name', 'unixa'),
        'menu_name' => __('نمونه کار', 'unixa'),
        'name_admin_bar' => __('نمونه کار', 'unixa'),
        'add_new_item' => __('نمونه کار جدید', 'unixa'),
        'edit_item' => __('ویرایش نمونه کار', 'unixa'),
        'new_item' => __('نمونه کار جدید', 'unixa'),
    );

    $args = array(
        'label' => __('Portfolio', 'unixa'),
        'labels' => $labels,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'capability_type' => 'post',
        'hierarchical' => false,
        'menu_position' => 5,
        'supports' => array('title', 'editor', 'thumbnail', 'excerpt', 'custom-fields'),
        'has_archive' => true,
        'rewrite' => array('slug' => 'portfolio'),
        'show_in_rest' => true, 
        'taxonomies' => array('portfolio_category'), 
    );

    register_post_type('portfolio', $args);
}
add_action('init', 'create_portfolio_cpt');

function create_portfolio_taxonomy() {
    $labels = array(
        'name' => _x('دسته بندی نمونه کار', 'taxonomy general name', 'unixa'),
        'singular_name' => _x('دسته بندی', 'taxonomy singular name', 'unixa'),
        'search_items' => __('جستجو', 'unixa'),
        'all_items' => __('همه دسته بندی ها', 'unixa'),
        'parent_item' => __('Parent Category', 'unixa'),
        'parent_item_colon' => __('Parent Category:', 'unixa'),
        'edit_item' => __('Edit Category', 'unixa'),
        'update_item' => __('Update Category', 'unixa'),
        'add_new_item' => __('Add New Category', 'unixa'),
        'new_item_name' => __('New Category Name', 'unixa'),
        'menu_name' => __('دسته بندی ها', 'unixa'),
    );

    $args = array(
        'hierarchical' => true,
        'labels' => $labels,
        'show_ui' => true,
        'show_admin_column' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'portfolio-category'),
        'show_in_rest' => true,
    );

    register_taxonomy('portfolio_category', array('portfolio'), $args);
}
add_action('init', 'create_portfolio_taxonomy');



add_action('rest_api_init', function() {
    register_rest_field('post', 'featured_image_url', array(
        'get_callback' => function($post_arr) {
            $img_id = get_post_thumbnail_id($post_arr['id']);
            if ($img_id) {
                $img_src = wp_get_attachment_image_src($img_id, 'full');
                return $img_src ? $img_src[0] : null;
            }
            return null;
        },
        'schema' => null,
    ));

});

add_filter('wpcf7_autop_or_not', '__return_false');
?>
