<?php
/* Template Name: Contact */
get_header();

$contact_form_title = get_field('contact_form_title');
$contact_image = get_field('contact_image');

$address = get_field('_address', 'option');
$email= get_field('_email', 'option');
$phone = get_field('_phone', 'option');
?>
<div class="page-wrap contact-page">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="page-header text-center">
                    <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                        <?php echo get_the_title(); ?>
                    </h1>
                    <?php get_template_part('templates/content/breadcrumb'); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-6">
                <div class="row justify-content-between">
                    <div class="col-12 col-md-4 col-lg-3 wow fadeInUp" data-wow-delay="0.5s">
                        <div class="contact-card text-center">
                            <span class="icon-wrapper mail"><i class="icon-mail"></i></span>
                            <p><a href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a></p>
                        </div>
                    </div>
                    <div class="col-12 col-md-4 col-lg-5 px-3 wow fadeInUp" data-wow-delay="0.25s">
                        <div class="contact-card text-center">
                            <span class="icon-wrapper location"><i class="icon-location"></i></span>
                            <p><?php echo $address; ?></p>
                        </div>
                    </div>
                    <div class="col-12 col-md-4 col-lg-3 wow fadeInUp" data-wow-delay="0.5s">
                        <div class="contact-card text-center">
                            <span class="icon-wrapper phone"><i class="icon-phone"></i></span>
                            <p><a class="ltr" href="tel:<?php echo $phone; ?>"><?php echo $phone; ?></a></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-6">
                <div class="contact-image">
                    <?php 
                    echo '<img src="' . $contact_image['url'] . '" width="' . $contact_image['width'] . '" height="' . $contact_image['height'] . '" alt="' . $contact_image['alt'] . '" />';
                    ?>
                </div>
            </div>
        </div>
    </div>

    <section class="contact-form">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-9 mx-auto">
                    <div class="contact-form-wrap">
                        <div class="section-head text-center">
                             <?php if($contact_form_title!='') { ?>
                                <h3 class="section-title  wow fadeInUp" data-wow-delay="0.5s"><?php echo $contact_form_title; ?></h3>
                            <?php }
                            ?>
                            <p class="page-desc wow fadeInUp" data-wow-delay="0.75s"><?php echo get_field('contact_desc'); ?></p>
                        </div>
                       
                        <?php
                        
                            echo do_shortcode('[contact-form-7 id="549d44a" title="Contact form 1"]');
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php get_footer('inner'); ?>

